/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/StatisticsGenerator.java#3 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.text.NumberFormat;
import java.util.Locale;

import com.sap.tc.jtools.jlint.statistics.MetricResult;
import com.sap.tc.jtools.jlint.statistics.MetricSummary;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jlint.statistics.TestSummary;

/**
 * @author SAP AG d034036
 *
 */
public class StatisticsGenerator {

	public static final NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);

	static {
		formatter.setGroupingUsed(false);
		formatter.setMaximumFractionDigits(2);
		//	   formatter.setMinimumFractionDigits(1);
	}

	public static String getTestSummaryTable(
		String runId,
		ResultStatistics resultStatistics,
		RunReportPageManager pageManager,
		Page callingPage) {
		
		TestSummary testSummary = resultStatistics.getTestSummary();
		if (testSummary.getTotalErrorCount() + testSummary.getTotalWarningCount() + testSummary.getTotalInfoCount()
			== 0)
			return "";
		String[] testNames = testSummary.getTestNames();

		StringBuffer sb = new StringBuffer();

		sb.append("<table border=\"1\" rules=\"groups\">");
		sb.append("<caption>Number of Messages</caption>");
		sb.append("<thead>");
		sb.append("<tr>");
		sb.append("<th>Test</th>");
		sb.append("<th>");
		sb.append("  <font color=\"maroon\">Prio 1</font> ");
		sb.append("  </th>");
		if (!pageManager.getRunReportConfiguration().isIgnoreWarnings()) {
			sb.append(" <th>");
			sb.append("  <font color=\"olive\">Prio 2</font>");
			sb.append("  </th>");
		}

		if (!pageManager.getRunReportConfiguration().isIgnoreInfos()) {
			sb.append(" <th>");
			sb.append("  <font color=\"green\">Prio 3</font>");
			sb.append("  </th>");
		}
		if (!(pageManager.getRunReportConfiguration().isIgnoreWarnings()
			&& pageManager.getRunReportConfiguration().isIgnoreInfos())) {
			sb.append("  <th>Total</th> ");
		}

		sb.append("  </tr>");

		sb.append("  </thead>");
		
		// begin table body
		StringBuffer tableBody = new StringBuffer();
		tableBody.append(" <tbody>");
		int totalErrors = 0;
		int totalWarnings = 0;
		int totalInfos = 0;
		for (int i = 0; i < testNames.length; i++) {

			int totalTestMessages = 0;
			String testName = testNames[i];
			if (!pageManager.getRunReportConfiguration().getTestFilter().acceptTest(testName))
				continue;
			String[] msgKeys =
				testSummary.getMessageKeys(
					testName,
					pageManager.getRunReportConfiguration().isIgnoreWarnings(),
					pageManager.getRunReportConfiguration().isIgnoreInfos());
			
			int errorCount = 0;
			int warningCount = 0;
			int infoCount = 0;
			
			for (int j = 0; j < msgKeys.length; j++) {
				if ( !pageManager.getRunReportConfiguration().getTestFilter().acceptMessage(testName,msgKeys[j]))
					continue;
				errorCount += testSummary.getErrorCountForTest(testName,msgKeys[j]);
				if (!pageManager.getRunReportConfiguration().isIgnoreWarnings()) {
					warningCount += testSummary.getWarningCountForTest(testName,msgKeys[j]);
				}
				if (!pageManager.getRunReportConfiguration().isIgnoreInfos()) {
					infoCount += testSummary.getInfoCountForTest(testName,msgKeys[j]);
				}

			}

			
			totalErrors += errorCount;
			totalTestMessages += errorCount;
			String tempString = "";
			tempString += "<tr>";
			tempString += " <td>";
			String link = pageManager.getLinkForTest(runId, testName, callingPage);
			if (link != null) {
				tempString += "<a href=\"" + link + "\">" + testName + "</a>";
			} else {
				tempString += testName;
			}
			tempString += "</td>";
			tempString += "<td align=\"right\">";
			tempString += errorCount;
			tempString += "</td>";
			if (!pageManager.getRunReportConfiguration().isIgnoreWarnings()) {
				totalWarnings += warningCount;
				totalTestMessages += warningCount;
				tempString += "<td align=\"right\">";
				tempString += warningCount;
				tempString += "</td>";
			}
			if (!pageManager.getRunReportConfiguration().isIgnoreInfos()) {
				totalInfos += infoCount;
				totalTestMessages += infoCount;
				tempString += "<td align=\"right\">";
				tempString += infoCount;
				tempString += "</td>";
			}
			if (totalTestMessages == 0)
				continue;
			tableBody.append(tempString);
			if (!(pageManager.getRunReportConfiguration().isIgnoreWarnings()
				&& pageManager.getRunReportConfiguration().isIgnoreInfos())) {
				tableBody.append("<td align=\"right\">");
				tableBody.append(totalTestMessages);
				tableBody.append("</td>");
			}

			tableBody.append("</tr>");
		}
		tableBody.append("</tbody>");
		// end table body
		
		// begin table footer
		sb.append("<tfoot>");
		sb.append("<tr>");
		sb.append("<td>");

		sb.append("<b>Total</b>");
		sb.append("</td>");
		sb.append("<td align=\"right\">");
		sb.append("<b>");
		sb.append(totalErrors);
		sb.append("</b>");
		sb.append("</td>");
		if (!pageManager.getRunReportConfiguration().isIgnoreWarnings()) {
			sb.append("<td align=\"right\">");
			sb.append("<b>");
			sb.append(totalWarnings);
			sb.append("</b>");
			sb.append("</td>");
		}
		if (!pageManager.getRunReportConfiguration().isIgnoreInfos()) {
			sb.append("<td align=\"right\">");
			sb.append("<b>");
			sb.append(totalInfos);
			sb.append("</b>");
			sb.append("</td>");
		}
		if (!(pageManager.getRunReportConfiguration().isIgnoreWarnings()
			&& pageManager.getRunReportConfiguration().isIgnoreInfos())) {
			sb.append("<td align=\"right\">");
			sb.append("<b>");
			sb.append(totalErrors + totalWarnings + totalInfos);
			sb.append("</b>");
			sb.append("</td>");
		}
		sb.append("</tr>");
		sb.append("</tfoot>");
		// end table footer
		
		// only now add table body:
		sb.append(tableBody.toString());
		
		sb.append("</table>");

		return sb.toString();
	}

	public static String getMetricSummaryTable(
		String runId,
		ResultStatistics resultStatistics,
		RunReportPageManager pageManager,
		Page callingPage) {
		MetricSummary metricSummary = resultStatistics.getMetricResult();

		MetricResult[] metricResults = metricSummary.getMetricResults();

		StringBuffer sb = new StringBuffer();

		sb.append("<table border=\"1\" rules=\"groups\">");
		sb.append("<caption>Global Metrics</caption>");
		sb.append("<thead>");
		sb.append("<tr>");
		sb.append("<th>Test</th>");
		sb.append("<th>Metric</th>");
		sb.append("<th>Sum</th>");
		sb.append("<th>Average</th>");
		sb.append("<th>Std. dev.</th>");
		sb.append("<th>Min</th>");
		sb.append("<th>Max</th>");
		sb.append("  </tr>");
		sb.append("  </thead>");
		sb.append(" <tbody>");
		for (int i = 0; i < metricResults.length; i++) {
			String testName = metricResults[i].getTestName();
			if (!pageManager.getRunReportConfiguration().getTestFilter().acceptTest(testName))
				continue;
			sb.append("<tr>");
			sb.append(" <td>");
			if (pageManager.getLinkForTest(runId, testName, callingPage) != null) {
				sb.append(
					"<a href=\""
						+ pageManager.getLinkForTest(runId, testName, callingPage)
						+ "\">"
						+ testName
						+ "</a>");
			} else {
				sb.append(testName);
			}
			sb.append("</td>");
			sb.append(" <td>" + metricResults[i].getMetricName() + "</td>");
			sb.append("<td align=\"right\">");
			if (metricResults[i].isSumDefined())
				sb.append(formatter.format(metricResults[i].getSum()));
			sb.append("</td>");
			sb.append("<td align=\"right\">");
			if (metricResults[i].isAverageDefined())
				sb.append(formatter.format(metricResults[i].getAverage()));
			sb.append("</td>");
			sb.append("<td align=\"right\">");
			if (metricResults[i].isStdDevDefined())
				sb.append(formatter.format(metricResults[i].getStdDev()));
			sb.append("</td>");
			sb.append("<td align=\"right\">");
			if (metricResults[i].isMinDefined())
				sb.append(formatter.format(metricResults[i].getMin()));
			sb.append("</td>");
			sb.append("<td align=\"right\">");
			if (metricResults[i].isMaxDefined())
				sb.append(formatter.format(metricResults[i].getMax()));
			sb.append("</td>");
			sb.append("</tr>");
		}
		sb.append("</tbody>");
		sb.append("</table>");

		return sb.toString();
	}

	public static String getSummary(
		String runId,
		ResultStatistics resultStatistics,
		RunReportPageManager pageManager,
		Page callingPage) {
		StringBuffer sb = new StringBuffer();
		sb.append("<table border=\"0\">");
		sb.append(" <tbody>");
		sb.append("<tr>");
		sb.append(" <td valign=\"top\">");
		sb.append(getTestSummaryTable(runId, resultStatistics, pageManager, callingPage));
		sb.append("</td>");
		sb.append("<td valign=\"top\">");
		sb.append(StatisticsGenerator.getMetricSummaryTable(runId, resultStatistics, pageManager, callingPage));
		sb.append("</td>");
		sb.append("</tr>");
		sb.append("</tbody>");
		sb.append("</table>");
		return sb.toString();
	}
}
