/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/RunSummaryPage.java#3 $
 */

package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jlint.statistics.TestSummary;

/**
 * @author SAP AG d034036
 *
 */
public class RunSummaryPage extends Page {

	private RunInterface data;
	private String contents;

	public RunSummaryPage(RunInterface data, String address, RunReportPageManager pageManager) {
		super(address, pageManager);
		this.data = data;
	}

	public String getContents() {
		if (contents == null) {
			RunReportPageManager rrManager = (RunReportPageManager)pageManager;
			StringBuffer sb = new StringBuffer(PAGE_HEADER_START);
			sb.append("JLin run " + data.getRunID());
			sb.append(PAGE_HEADER_END);
			sb.append("<body style=\"font-family: arial;\"><h2>");
			sb.append("JLin run " + data.getRunID());
			sb.append("</h2>");
			sb.append("<hr><p>");

			ResultStatistics statistics = data.getGlobalResults(rrManager.getRunReportConfiguration().getProjectFilter());

			sb.append(StatisticsGenerator.getSummary(data.getRunID(), statistics, rrManager, this));

			sb.append("<hr><p>");
			ProjectRunInterface[] projectRuns = data.getProjectsRuns();
			if (projectRuns.length > 0) {
				sb.append("<p><table border=\"1\" rules=\"groups\">");
				sb.append("<caption>Projects:</caption>");
				sb.append("<thead><tr><th>Project</th>");
				sb.append("<th>");
				sb.append("  <font color=\"maroon\">Prio 1</font> ");
				sb.append("  </th>");
				sb.append(" <th>");
				sb.append("  <font color=\"olive\">Prio 2</font>");
				sb.append("  </th>");
				sb.append(" <th>");
				sb.append("  <font color=\"green\">Prio 3</font>");
				sb.append("  </th>");
				sb.append(" <th>Total</th>");
				sb.append("  </tr></thead>");
				
		         // begin table body
		         StringBuffer tableBody = new StringBuffer();
		         tableBody.append("<tbody>");
				int totalErrorCount, totalWarningCount, totalInfoCount, totalAllCount;
				totalErrorCount= totalWarningCount= totalInfoCount= totalAllCount=0;
				for (int i = 0; i < projectRuns.length; i++) {
					String projectId = projectRuns[i].getProjectId();
					if (rrManager.getRunReportConfiguration().getProjectFilter().acceptProject(projectId)) {
            TestSummary summary = projectRuns[i].getStatistics().getTestSummary();
						tableBody.append(
							"<tr><td>"
								+ "<a href=\""
								+ rrManager.getLinkForProjectRun(data.getRunID(), projectId, this)
								+ "\">"
								+ projectId
								+ "</a></td>");
						 int errorCount = summary.getTotalErrorCount();
						 totalErrorCount += errorCount;
						 int warningCount = summary.getTotalWarningCount();
						 totalWarningCount +=warningCount;
						 int infoCount = summary.getTotalInfoCount();
						 totalInfoCount+=infoCount;
						 int allCount = errorCount + warningCount + infoCount;
						 totalAllCount +=allCount;
             tableBody.append("<td align=\"right\">"+ errorCount+"</td>");						
             tableBody.append("<td align=\"right\">"+ warningCount +"</td>");						
             tableBody.append("<td align=\"right\">"+ infoCount+"</td>");						
             tableBody.append("<td align=\"right\">"+ allCount +"</td></tr>");						
					}
				}
		     tableBody.append("</tbody>");
		     // end table body
		     
		     // begin table footer
			 sb.append("<tfoot>");
       sb.append("<tr><td><b>Total</b></td>");						
       sb.append("<td align=\"right\"><b>"+ totalErrorCount+"</b></td>");						
       sb.append("<td align=\"right\"><b>"+ totalWarningCount +"</b></td>");						
       sb.append("<td align=\"right\"><b>"+ totalInfoCount+"</b></td>");						
       sb.append("<td align=\"right\"><b>"+ totalAllCount +"</b></td></tr>");						
			 sb.append("</tfoot>");
			 // end table footer

			 // only now append table body:
			 sb.append(tableBody.toString());
			 
       sb.append("</table>");
			}

			sb.append("</body></html>");
			contents = sb.toString();
		}
		return contents;

	}

}
