/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/RunReportPageManager.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunSummaryInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author SAP AG d034036
 *
 */
public class RunReportPageManager extends PageManager {


	protected static final String PROJECT_DIRECTORY = "projects";
	protected static final String TEST_DIRECTORY = "tests";
	private static final String VARIANT_DIRECTORY = "variants";


	private Map runSummaryPages = new HashMap();
	private Map testDescriptionPages = new HashMap();
	protected Map testDescriptionMap = new HashMap();
	private Map variantPages = new HashMap();
	private Map projectRunPages = new HashMap();

//	private RunSummaryInterface[] runs;

	private RunReportConfiguration runConfiguration;

	public RunReportPageManager(
		RunReportConfiguration runReportConfiguration,
		String rootDirectoryPath,
		boolean cleanUp) {
		super(rootDirectoryPath,cleanUp);
		this.runConfiguration = runReportConfiguration;
	}

 

	public RunSummaryPage createRunSummary(RunInterface data) {
		RunSummaryPage page = new RunSummaryPage(data, data.getRunID() + "/summary.html", this);
		runSummaryPages.put(data.getRunID(), page);
		allPages.add(page);
		return page;
	}

	public TestDescriptionPage createTestDescriptionPage(String runID, TestDescriptionSet tests) {
		TestDescriptionPage page =
			new TestDescriptionPage(
				tests,
				runID + "/" + TEST_DIRECTORY + "/" + tests.getName() + "_description.html",
				this);
		TestDescriptionInterface[] testDescriptions = tests.getTestTree().getAllLeaves();
		for (int i = 0; i < testDescriptions.length; i++) {
			Map test2Page = (Map) testDescriptionPages.get(runID);
			if (test2Page == null) {
				test2Page = new HashMap();
				testDescriptionPages.put(runID, test2Page);
			}
			test2Page.put(testDescriptions[i].getName(), page);
			testDescriptionMap.put(testDescriptions[i].getName(), testDescriptions[i]);
		}
		allPages.add(page);
		return page;
	}

	public VariantPage createVariantPage(ProjectRunInterface run, TestSet variant) {
		VariantPage page =
			new VariantPage(
				variant,
				 	 run.getRunId()
					+ "/"
					+ PROJECT_DIRECTORY
					+ "/"
					+ run.getProjectId()
					+ "/"
					+ VARIANT_DIRECTORY
					+ "/"
					+ variant.getName()
					+ ".html",
				this);
		variantPages.put(run, page);
		allPages.add(page);
		return page;
	}

 

	public ProjectRunSummaryPage createProjectRunPage(ProjectRunInterface run) {
		String address =
			run.getRunId() + "/" + PROJECT_DIRECTORY + "/" + run.getProjectId() + "/summary.html";
		ProjectRunSummaryPage page = new ProjectRunSummaryPage(run, address, this);
		ResultStatistics statistics = page.getStatistics();
		if (statistics != null) {

			try {
				File statFile =
					new File(
						rootDirectory,
							run.getRunId()
							+ "/"
							+ PROJECT_DIRECTORY
							+ "/"
							+ run.getProjectId()
							+ "/statistics.xml");
				statFile.getParentFile().mkdirs();
				XMLTool.writeDocument(statistics.toStructureTree(), new FileWriter(statFile));
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		projectRunPages.put(run, page);
		allPages.add(page);
		return page;

	}

	/* get links*/
	public String getLinkForTest(String runId, String testId, Page callingPage) {
		try {
			return getRelativeLink(
				((Page) ((Map) testDescriptionPages.get(runId)).get(testId)).getAddress() + "#" + testId,
				callingPage.getAddress());
		} catch (Exception e) {
			return null;
		}
	}

//	public String getLinkForRun(String runId, Page callingPage) {
//		String runPath = rootDirectory.getAbsolutePath()  + "/" + runId; //default
//		for (int i = 0; i < runs.length; i++) {
//			if (runs[i].getRunID().equals(runId)) {
//				runPath = runs[i].getRunRootDirectory();
//				break;
//			}
//		}
//		return getRelativeLink(
//			runPath + "/summary.html",
//			rootDirectory.getAbsolutePath() + "/" + callingPage.getAddress());
//	}



	public String getLinkForProjectRun(String runId, String projectId, Page callingPage) {
		for (Iterator iter = projectRunPages.keySet().iterator(); iter.hasNext();) {
			ProjectRunInterface projectRun = (ProjectRunInterface) iter.next();
			if (projectRun.getProjectId().equals(projectId) && projectRun.getRunId().equals(runId))
				return getRelativeLink(((Page) projectRunPages.get(projectRun)).getAddress(), callingPage.getAddress());
		}
		String runPath = rootDirectory.getAbsolutePath() + "/" + runId; //default
//		for (int i = 0; i < runs.length; i++) {
//			if (runs[i].getRunID().equals(runId)) {
//				runPath = runs[i].getRunRootDirectory();
//				break;
//			}
//		}
		return getRelativeLink(
			runPath + "/" + PROJECT_DIRECTORY + "/" + projectId + "/summary.html",
			rootDirectory.getAbsolutePath() + "/" + callingPage.getAddress());		
 
	}

	public String getLinkForVariant(ProjectRunInterface run, Page callingPage) {
		return getRelativeLink(((Page) variantPages.get(run)).getAddress(), callingPage.getAddress());
	}

	/**
	 * @return
	 */
	public RunReportConfiguration getRunReportConfiguration() {
		return runConfiguration;
	}

}
