/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/RunReportManager.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.io.File;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ff.impl.RunSummary;
import com.sap.tc.jtools.jtci.TestSet;

/**
 * @author SAP AG d034036
 *
 */
public class RunReportManager {

	private RunReportConfiguration reportConfiguration;

	public RunReportManager(RunReportConfiguration reportConfiguration) {
		this.reportConfiguration = reportConfiguration;
	}

	public RunSummaryInterface createRunReport(RunInterface run, String outputDirectoryPath) {

		RunReportPageManager pageManager = new RunReportPageManager(reportConfiguration, outputDirectoryPath, false);

		TestDescriptionSet[] testDescriptionSets = run.getTestDescriptionSets();
		for (int j = 0; j < testDescriptionSets.length; j++) {
			pageManager.createTestDescriptionPage(run.getRunID(), testDescriptionSets[j]);
		}
		RunSummaryPage runPage = pageManager.createRunSummary(run);

		ProjectRunInterface[] projectRuns = run.getProjectsRuns();
		for (int j = 0; j < projectRuns.length; j++) {
			if (!reportConfiguration.getProjectFilter().acceptProject(projectRuns[j].getProjectId()))
				continue;
			TestSet testVariant = projectRuns[j].getTestVariant();
			pageManager.createVariantPage(projectRuns[j], testVariant);
			pageManager.createProjectRunPage(projectRuns[j]);
			pageManager.saveAll();
		}

		pageManager.saveAll();

		return new RunSummary(new File(outputDirectoryPath, runPage.getAddress()).getParentFile());

	}

}