/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/RunReportConfiguration.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * @author SAP AG d034036
 *
 */
public class RunReportConfiguration {

	private static final TestFilterInterface DEFAULT_TEST_FILTER = new TestFilterInterface() {
		public boolean acceptTest(String testId) {
			return true;
		}

		public boolean acceptMessage(String testId, String msgKey) {
			return true;
		}
	};

	private static final ProjectFilterInterface DEFAULT_PROJECT_FILTER = new ProjectFilterInterface() {
		public boolean acceptProject(String projectId) {
			return true;
		}
	};

	private ProjectFilterInterface projectFilter = DEFAULT_PROJECT_FILTER;
	private TestFilterInterface testFilter = DEFAULT_TEST_FILTER;
	private boolean displayIndividualMessages = true;
	private boolean displayMetricSummary = true; //not used
	private boolean displayTestSummary = true; //not used
	private boolean ignoreInfos = false;
	private boolean ignoreWarnings = false;

	public RunReportConfiguration() {
	}

	public RunReportConfiguration(StructureTree tree) {

		if (tree.getParameter("DISPLAY_INDIVIDUAL_MESSAGES") != null) {
			displayIndividualMessages = new Boolean(tree.getParameter("DISPLAY_INDIVIDUAL_MESSAGES")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_METRIC_SUMMARY") != null) {
			displayMetricSummary = new Boolean(tree.getParameter("DISPLAY_METRIC_SUMMARY")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_TEST_SUMMARY") != null) {
			displayTestSummary = new Boolean(tree.getParameter("DISPLAY_TEST_SUMMARY")).booleanValue();
		}

		if (tree.getParameter("IGNORE_INFOS") != null) {
			ignoreInfos = new Boolean(tree.getParameter("IGNORE_INFOS")).booleanValue();
		}

		if (tree.getParameter("IGNORE_WARNINGS") != null) {
			ignoreWarnings = new Boolean(tree.getParameter("IGNORE_WARNINGS")).booleanValue();
		}

		StructureTree projectFilterTree = tree.getOnlyChild("PROJECT_FILTER");
		if (projectFilterTree != null) {
			StructureTree[] projectNameTrees = projectFilterTree.getChildren("PROJECT");
			final String[] projectNames = new String[projectNameTrees.length];
			for (int i = 0; i < projectNames.length; i++) {
				projectNames[i] = projectNameTrees[i].getParameter("ID");
			}
			projectFilter = new ProjectFilterInterface() {
				public boolean acceptProject(String projectId) {
					for (int i = 0; i < projectNames.length; i++) {
						if (projectNames[i].equals(projectId))
							return true;
					}
					return false;
				}
			};
		}

		StructureTree testFilterTree = tree.getOnlyChild("TEST_FILTER");
		if (testFilterTree != null) {
			StructureTree[] testNameTrees = testFilterTree.getChildren("TEST");
			final List okTests = new ArrayList();
			final Map okMsgKeys = new HashMap();
			//			final String[] testNames = new String[testNameTrees.length];
			for (int i = 0; i < testNameTrees.length; i++) {
				String testName = testNameTrees[i].getParameter("ID");
				StructureTree[] okKeyTrees = testNameTrees[i].getChildren("KEY_MSG");
				if (okKeyTrees.length == 0) {
					okTests.add(testName);
				} else {
					String[] okKeys = new String[okKeyTrees.length];
					for (int j = 0; j < okKeys.length; j++) {
						okKeys[j] = okKeyTrees[j].getParameter("KEY");
					}
					okMsgKeys.put(testName, okKeys);
				}
			}
			testFilter = new TestFilterInterface() {
				public boolean acceptTest(String testId) {
					for (Iterator iter = okTests.iterator(); iter.hasNext();) {
						String test = (String) iter.next();
						if (test.equals(testId))
							return true;
					}
					for (Iterator iter = okMsgKeys.keySet().iterator(); iter.hasNext();) {
						String test = (String) iter.next();
						if (test.equals(testId))
							return true;
					}
					return false;
				}

				public boolean acceptMessage(String testId, String msgKey) {
					for (Iterator iter = okTests.iterator(); iter.hasNext();) {
						String test = (String) iter.next();
						if (test.equals(testId))
							return true;
					}
					for (Iterator iter = okMsgKeys.keySet().iterator(); iter.hasNext();) {
						String test = (String) iter.next();
						if (test.equals(testId)) {
							String[] okKeys = (String[]) okMsgKeys.get(test);
							for (int i = 0; i < okKeys.length; i++) {
								if (msgKey.equals(okKeys[i]))
									return true;
							}
							return false;
						}
					}
					return false;
				}
			};
		}

	}

	/**
	 * @return
	 */
	public boolean isDisplayIndividualMessages() {
		return displayIndividualMessages;
	}

	/**
	 * @return
	 */
	public boolean isDisplayMetricSummary() {
		return displayMetricSummary;
	}

	/**
	 * @return
	 */
	public boolean isDisplayTestSummary() {
		return displayTestSummary;
	}

	/**
	 * @return
	 */
	public ProjectFilterInterface getProjectFilter() {
		return projectFilter;
	}

	/**
	 * @return
	 */
	public TestFilterInterface getTestFilter() {
		return testFilter;
	}

	/**
	 * @param b
	 */
	public void setDisplayIndividualMessages(boolean b) {
		displayIndividualMessages = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayMetricSummary(boolean b) {
		displayMetricSummary = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayTestSummary(boolean b) {
		displayTestSummary = b;
	}

	/**
	 * @param interface1
	 */
	public void setProjectFilter(ProjectFilterInterface interface1) {
		projectFilter = interface1;
	}

	/**
	 * @param interface1
	 */
	public void setTestFilter(TestFilterInterface interface1) {
		testFilter = interface1;
	}

	/**
	 * @return
	 */
	public boolean isIgnoreInfos() {
		return ignoreInfos;
	}

	/**
	 * @return
	 */
	public boolean isIgnoreWarnings() {
		return ignoreWarnings;
	}

	/**
	 * @param b
	 */
	public void setIgnoreInfos(boolean b) {
		ignoreInfos = b;
	}

	/**
	 * @param b
	 */
	public void setIgnoreWarnings(boolean b) {
		ignoreWarnings = b;
	}

}
