/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/RunReport.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.io.File;
import java.io.FileReader;

import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ff.impl.Run;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author SAP AG d034036
 *
 */
public class RunReport {

	// arg[0]: run directory path
	// arg[1]: output directory
	// arg[2]: run report configuration (optional)
	public static void main(final String[] args) {
		String rootDirectoryPath = args[0];

		File rootDirectory = new File(rootDirectoryPath);

		if (rootDirectory.exists() && rootDirectory.isDirectory()) {
		
			RunReportConfiguration rc;
			if (args.length >= 3) {
				try {
					rc = new RunReportConfiguration(XMLTool.parseReader(new FileReader(args[2])));
				} catch (Exception e) {
					rc = new RunReportConfiguration();
				}
			} else {
				rc = new RunReportConfiguration();
			}

			RunReportManager rm = new RunReportManager(rc);
			RunInterface run = new Run(new File(args[0]));
 
 
			rm.createRunReport(run, args[1]);
		} else {
			System.out.println("invalid file: " + rootDirectoryPath + " - exit");
		}

	}
}
