/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/ResultFormatter.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.statistics.MetricResult;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 * @author SAP AG d034036
 *
 */
public class ResultFormatter {

	public static String getResultTable(String runId,ResultInterface[] results, RunReportPageManager pageManager, Page callingPage) {

		StringBuffer sb = new StringBuffer();
		sb.append("<table border=\"1\">");
		sb.append("<th>Test</th>");
		sb.append("<th>Message</th>");
		sb.append("<th>File</th>");
		sb.append("<th>Line</th>");
		sb.append("<th>Column</th>");
		sb.append("<th>Priority</th>");
		for (int i = 0; i < results.length; i++) {
			int prio = results[i].getPriority();
			if (prio > Result.SEVERITY_INFO || prio < Result.SEVERITY_ERROR)
				continue;
			if (prio == Result.SEVERITY_INFO && pageManager.getRunReportConfiguration().isIgnoreInfos())
				continue;
			if (prio == Result.SEVERITY_WARNING && pageManager.getRunReportConfiguration().isIgnoreWarnings())
				continue;
			if ( MetricResult.isGlobalMetricResult(results[i]))
				continue;
			String testName = results[i].getTestName();
			if (!pageManager.getRunReportConfiguration().getTestFilter().acceptTest(testName))
				continue;
			String msgKey = results[i].getErrorParameters().getProperty("__MSG_KEY");
			if ( msgKey != null && !pageManager.getRunReportConfiguration().getTestFilter().acceptMessage(testName,msgKey))
				continue;
			String message = results[i].getErrorText();
			
			String link = results[i].getErrorParameters().getProperty("__LINK");
			TestObjectPosition position = results[i].getResultPosition();

			sb.append("<tr>");
			sb.append("<td>");
			if (pageManager.getLinkForTest(runId,testName, callingPage) != null) {
				sb.append("<a href=\"" + pageManager.getLinkForTest(runId,testName, callingPage) + "\">" + testName + "</a>");
			} else {
				sb.append(testName);
			}

			sb.append("</td>");
			sb.append("<td>");
			if (link != null && !link.trim().equals("")) {
				sb.append("<a href=\"" + link + "\">" + message + "</a>");
			} else {
				sb.append(message);
			}

			sb.append("</td>");
			if (position instanceof FilePosition) {
				FilePosition filePosition = (FilePosition) position;
				sb.append("<td>");
				sb.append(filePosition.getFile());
				sb.append("</td>");
				int line = filePosition.getLine();
				int column = filePosition.getColumn();
				if (line != -1) {
					sb.append("<td>");
					sb.append(line);
					sb.append("</td>");
				} else {
					sb.append("<td>");
					sb.append("");
					sb.append("</td>");
				}
				if (column != -1) {
					sb.append("<td>");
					sb.append(column);
					sb.append("</td>");
				} else {
					sb.append("<td>");
					sb.append("");
					sb.append("</td>");
				}
			} else {
				sb.append("<td>");
				sb.append("");
				sb.append("</td>");
				sb.append("<td>");
				sb.append("");
				sb.append("</td>");
				sb.append("<td>");
				sb.append("");
				sb.append("</td>");
			}
			sb.append("<td>");
			sb.append(prio);
			sb.append("</td>");
			sb.append("</tr>");



		}
		sb.append("</table>");
		return sb.toString();
	}
}
