/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/ReportConfiguration.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * @author SAP AG d034036
 *
 */
public class ReportConfiguration {

	private static final RunFilterInterface DEFAULT_RUN_FILTER = new RunFilterInterface() {
		public boolean acceptRun(String runId) {
			return true;
		}
	};

	private String title = "JLin Report";
	private String description = "";

	private RunFilterInterface runFilter = DEFAULT_RUN_FILTER;

	private boolean displayTotalCountHistory = true;
	private boolean displayCountPerClassHistory = false;
	private boolean displayCountPerLocHistory = true;
	private boolean displayTestCountHistory = true;
	private boolean displayHistoryForMsg = true;
	private int maxMsgKeyNumber = 4;
	private RunReportConfiguration rrc = new RunReportConfiguration();

	public ReportConfiguration() {
	}

	public ReportConfiguration(StructureTree tree) {
		title = tree.getOnlyChild("TITLE").getText();
		description = tree.getOnlyChild("DESCRIPTION").getText();

		if (tree.getParameter("DISPLAY_TOTAL_COUNT_HISTORY") != null) {
			displayTotalCountHistory = new Boolean(tree.getParameter("DISPLAY_TOTAL_COUNT_HISTORY")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_COUNT_PER_CLASS_HISTORY") != null) {
			displayCountPerClassHistory =
				new Boolean(tree.getParameter("DISPLAY_COUNT_PER_CLASS_HISTORY")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_COUNT_PER_LOC_HISTORY") != null) {
			displayCountPerLocHistory = new Boolean(tree.getParameter("DISPLAY_COUNT_PER_LOC_HISTORY")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_TEST_COUNT_HISTORY") != null) {
			displayTestCountHistory = new Boolean(tree.getParameter("DISPLAY_TEST_COUNT_HISTORY")).booleanValue();
		}
		if (tree.getParameter("DISPLAY_HISTORY_FOR_MSG") != null) {
			displayHistoryForMsg = new Boolean(tree.getParameter("DISPLAY_HISTORY_FOR_MSG")).booleanValue();
			if (displayHistoryForMsg && tree.getParameter("MAX_MSG_KEY_NUMBER") != null) {
				maxMsgKeyNumber = Integer.parseInt(tree.getParameter("MAX_MSG_KEY_NUMBER"));
			}
		}

		StructureTree runConfigurationTree = tree.getOnlyChild("RUN_CONFIGURATION");
		if ( runConfigurationTree != null ) {
			rrc = new RunReportConfiguration(runConfigurationTree);
		}
		
		StructureTree runFilterTree = tree.getOnlyChild("RUN_FILTER");
		if (runFilterTree != null) {
			StructureTree[] runNameTrees = runFilterTree.getChildren("RUN");
			final String[] runNames = new String[runNameTrees.length];
			for (int i = 0; i < runNames.length; i++) {
				runNames[i] = runNameTrees[i].getParameter("ID");
			}
			runFilter = new RunFilterInterface() {
				public boolean acceptRun(String runId) {
					for (int i = 0; i < runNames.length; i++) {
						if (runNames[i].equals(runId))
							return true;
					}
					return false;
				}
			};
		}

	}

	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return
	 */
	public boolean isDisplayCountPerClassHistory() {
		return displayCountPerClassHistory;
	}

	/**
	 * @return
	 */
	public boolean isDisplayCountPerLocHistory() {
		return displayCountPerLocHistory;
	}

	/**
	 * @return
	 */
	public boolean isDisplayHistoryForMsg() {
		return displayHistoryForMsg;
	}

	/**
	 * @return
	 */
	public boolean isDisplayTestCountHistory() {
		return displayTestCountHistory;
	}

	/**
	 * @return
	 */
	public boolean isDisplayTotalCountHistory() {
		return displayTotalCountHistory;
	}

	/**
	 * @return
	 */
	public int getMaxMsgKeyNumber() {
		return maxMsgKeyNumber;
	}

	/**
	 * @return
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param string
	 */
	public void setDescription(String string) {
		description = string;
	}

	/**
	 * @param b
	 */
	public void setDisplayCountPerClassHistory(boolean b) {
		displayCountPerClassHistory = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayCountPerLocHistory(boolean b) {
		displayCountPerLocHistory = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayHistoryForMsg(boolean b) {
		displayHistoryForMsg = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayTestCountHistory(boolean b) {
		displayTestCountHistory = b;
	}

	/**
	 * @param b
	 */
	public void setDisplayTotalCountHistory(boolean b) {
		displayTotalCountHistory = b;
	}

	/**
	 * @param i
	 */
	public void setMaxMsgKeyNumber(int i) {
		maxMsgKeyNumber = i;
	}

	/**
	 * @param string
	 */
	public void setTitle(String string) {
		title = string;
	}

	/**
	 * @return
	 */
	public RunFilterInterface getRunFilter() {
		return runFilter;
	}

	/**
	 * @param interface1
	 */
	public void setRunFilter(RunFilterInterface interface1) {
		runFilter = interface1;
	}

	/**
	 * @return
	 */
	public RunReportConfiguration getRunReportConfiguration() {
		return rrc;
	}

	/**
	 * @param configuration
	 */
	public void setRunReportConfiguration(RunReportConfiguration configuration) {
		rrc = configuration;
	}

}
