/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/ProjectRunSummaryPage.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.util.Iterator;
import java.util.Properties;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.PerformResponse;

/**
 * @author SAP AG d034036
 *
 */
public class ProjectRunSummaryPage extends Page {

	private ProjectRunInterface data;
	private String contents;
	private String runId;
	private ResultStatistics statistics;

	public ProjectRunSummaryPage(ProjectRunInterface data, String address, RunReportPageManager pageManager) {
		super(address, pageManager);
		this.data = data;
		this.runId = data.getRunId();
		this.statistics = data.getStatistics();
	}

	public ResultStatistics getStatistics() {
		return statistics;
	}

	public String getContents() {
		RunReportPageManager rrManager = (RunReportPageManager)pageManager;
		if (contents == null) {
			StringBuffer sb = new StringBuffer(PAGE_HEADER_START);
			sb.append("JLin run - Project " + data.getProjectId() + ", run " + runId);
			sb.append(PAGE_HEADER_END);
			sb.append("<body style=\"font-family: arial;\"><h2>");
			sb.append("JLin run - Project " + data.getProjectId() + ", run " + runId);
			sb.append("</h2>");
			sb.append("<p>");
			PerformResponse[] runIndex = data.getResults();
			if (runIndex != null && runIndex.length > 0) {
				// hopefully these properties areconsistens across project sub-runs...
				sb.append("<p>NAME: " + runIndex[0].getName());
				Properties props = runIndex[0].getProperties();
				for (Iterator iter = props.keySet().iterator(); iter.hasNext();) {
					String key = (String) iter.next();
					String value = props.getProperty(key);
					sb.append("<p>" + key + ": " + value);
				}
			}
			sb.append("<hr><p>");
			if (rrManager.getLinkForVariant(data, this) != null) {
				sb.append("<p><a href=\"" + rrManager.getLinkForVariant(data, this) + "\">Executed tests</a>");
			}

			if (statistics != null) {
				sb.append(StatisticsGenerator.getSummary(runId, statistics, rrManager, this));
				sb.append("<p>");
				if (runIndex.length > 1) {
					sb.append("<hr><p><b>Sub-runs</b><p>");
					sb.append("<table border=\"0\" rules=\"groups\">");
					sb.append(" <tbody>");

					for (int i = 0; i < runIndex.length; i++) {
						ResultStatistics rs = new ResultStatistics(runIndex[i].getResults());
						sb.append("<tr>");
						sb.append(" <td>");
						sb.append(StatisticsGenerator.getSummary(runId, rs, rrManager, this));
						sb.append("</td>");
						sb.append("</tr>");
					}
					sb.append("</tbody>");
					sb.append("</table>");
				}
				if (rrManager.getRunReportConfiguration().isDisplayIndividualMessages()) {
					sb.append("<h3>Details</h3>");
					sb.append("<table border=\"0\" rules=\"groups\">");
					sb.append(" <tbody>");
					for (int i = 0; i < runIndex.length; i++) {
						sb.append("<tr>");
						sb.append(" <td>");
						sb.append(ResultFormatter.getResultTable(runId, runIndex[i].getResults(), rrManager, this));
						sb.append("</td>");
						sb.append("</tr>");
					}
					sb.append("</tbody>");
					sb.append("</table>");
				}

			}
			sb.append("</body></html>");
			contents = sb.toString();
		}
		return contents;

	}

}
