/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/html/PageManager.java#2 $
 */

package com.sap.tc.jtools.jlint.report.html;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/**
 * @author SAP AG d034036
 *
 */
public class PageManager {

	protected static final String PROJECT_DIRECTORY = "projects";
	protected static final String TEST_DIRECTORY = "tests";
	protected static final String VARIANT_DIRECTORY = "variants";

	protected List allPages = new ArrayList();

	protected File rootDirectory;

	public PageManager(String rootDirectoryPath, boolean cleanUp) {
		this.rootDirectory = new File(rootDirectoryPath);

		if (rootDirectory.exists() && cleanUp) {
			cleanUp(rootDirectory);
		}
		rootDirectory.mkdirs();
	}

	public void saveAll() {
		for (Iterator iter = allPages.iterator(); iter.hasNext();) {
			try {
				Page page = (Page) iter.next();
				String content = page.getContents();
				File file = new File(rootDirectory, page.getAddress());
				file.getParentFile().mkdirs();
				FileWriter fr = new FileWriter(file);
				fr.write(content);
				fr.flush();
				fr.close();
				iter.remove();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private void cleanUp(File f) {
		if (f.isDirectory()) {
			File[] children = f.listFiles();
			for (int i = 0; i < children.length; i++) {
				cleanUp(children[i]);
			}
		}
		f.delete();

	}

	protected String getRelativeLink(String link, String relativeTo) {
		if (link == null | link.trim().equals(""))
			return null;

		StringTokenizer linkTokens = new StringTokenizer(link.replace('\\', '/'), "/");
		StringTokenizer relativeToTokens = new StringTokenizer(relativeTo.replace('\\', '/'), "/");
		if (link.equals(relativeTo)) {
			String out = "";
			while (linkTokens.hasMoreTokens()) {
				out = linkTokens.nextToken();
			}
			if (out == null || out.trim().equals(""))
				return null;
			return out;
		}
		return getRelativeLink(linkTokens, relativeToTokens);
	}

	private String getRelativeLink(StringTokenizer linkTokens, StringTokenizer relativeToTokens) {
		String linkToken = linkTokens.nextToken();
		String relativeToToken = relativeToTokens.nextToken();

		if (linkToken.equals(relativeToToken)) {
			return getRelativeLink(linkTokens, relativeToTokens);
		}

		String out = "";
		for (int i = 0; i < relativeToTokens.countTokens(); i++) {
			out += "../";
		}
		out += linkToken;
		while (linkTokens.hasMoreTokens()) {
			out += "/" + linkTokens.nextToken();
		}
		return out;
	}

}
