/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/dataprovider/ff/impl/RunSummary.java#2 $
 */

package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunSummaryInterface;
import com.sap.tc.jtools.jlint.report.html.ProjectFilterInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;

/**
 * @author SAP AG d034036
 *
 */
public class RunSummary implements RunSummaryInterface {

	private File runDir;
	private ProjectRunSummaryInterface[] projects;
	private ResultStatistics globalResults;


	public RunSummary(File runDir) {
		this.runDir = runDir;
 		File projectDir = new File(runDir,"projects");
		List projectList = new ArrayList();
		File[] projectDirectories = projectDir.listFiles(new FileFilter() {
			public boolean accept(File pathname) {
				if (!pathname.isDirectory())
					return false;

				return true;
			}
		});
		projects = new ProjectRunSummaryInterface[projectDirectories.length];
		for (int i = 0; i < projectDirectories.length; i++) {
			projects[i] = new ProjectRunSummary(projectDirectories[i].getName(), getRunID(), projectDirectories[i]);
		}
 
	}

	public String getRunID() {
		return runDir.getName();
	}

	public ResultStatistics getGlobalResults() {
		List projectSummaryList = new ArrayList();
 
		for (int i = 0; i < projects.length; i++) {
			ResultStatistics rs  = projects[i].getStatistics();
			if ( rs != null ) {
				projectSummaryList.add(rs);
			}
		}
		return ResultStatistics.merge((ResultStatistics[])projectSummaryList.toArray(new ResultStatistics[0]));
	}

	public ProjectRunSummaryInterface[] getProjectSummaries() {
		return projects;
	}
	
	public String getRunRootDirectory() {
		return runDir.getAbsolutePath();
	}

	public ResultStatistics getGlobalResults(ProjectFilterInterface projectFilter) {
		List projectSummaryList = new ArrayList();
 
		for (int i = 0; i < projects.length; i++) {
			if ( !projectFilter.acceptProject(projects[i].getProjectId()))
				continue;
			ResultStatistics rs  = projects[i].getStatistics();
			if ( rs != null ) {
				projectSummaryList.add(rs);
			}
		}
		return ResultStatistics.merge((ResultStatistics[])projectSummaryList.toArray(new ResultStatistics[0]));
	}

}
