/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/dataprovider/ff/impl/Run.java#2 $
 */

package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.html.ProjectFilterInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author SAP AG d034036
 *
 */
public class Run implements RunInterface {

	private File runDir;
	private ProjectRunInterface[] projects;
	private ResultStatistics globalResults;
	private TestDescriptionSet[] testDescriptionSets;

	public Run(File runDir) {
		this.runDir = runDir;
		File testDirectory = new File(runDir, "jlin_settings/tests");
		File[] testDescriptorFiles = testDirectory.listFiles();
		List testDescriptionList = new ArrayList();
		for (int i = 0; i < testDescriptorFiles.length; i++) {
			try {
				testDescriptionList.add(
					new TestDescriptionSet(XMLTool.parseReader(new FileReader(testDescriptorFiles[i]))));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		testDescriptionSets =
			(TestDescriptionSet[]) testDescriptionList.toArray(new TestDescriptionSet[testDescriptorFiles.length]);

		List projectList = new ArrayList();
		File[] projectDirectories = runDir.listFiles(new FileFilter() {
			public boolean accept(File pathname) {
				if (!pathname.isDirectory() || pathname.getName().equals("jlin_settings"))
					return false;
				return true;
			}
		});
		projects = new ProjectRunInterface[projectDirectories.length];
		TestSet defaultVariant = null;
		try {
			defaultVariant =
				new TestSet(
					XMLTool.parseReader(new FileReader(new File(runDir, "jlin_settings/variants/testconfig.xml"))));
		} catch (Exception e) {
			e.printStackTrace();
		}
		for (int i = 0; i < projectDirectories.length; i++) {
			TestSet variant = defaultVariant;
			File projectVariant = new File(projectDirectories[i], "jlin_settings/variants/testconfig.xml");
			if (projectVariant.exists()) {
				try {
					variant = new TestSet(XMLTool.parseReader(new FileReader(projectVariant)));
				} catch (Exception e1) {
					e1.printStackTrace();
				}
			}

			projects[i] = new ProjectRun(projectDirectories[i].getName(), getRunID(), variant, projectDirectories[i]);
		}

	}

	public String getRunID() {
		return runDir.getName();
	}

	public ResultStatistics getGlobalResults() {
		return getGlobalResults(null);
	}

	public ResultStatistics getGlobalResults(ProjectFilterInterface projectFilter) {
		if (globalResults == null) {
			ResultStatistics[] projectStats = new ResultStatistics[projects.length];
			List projectStatList = new ArrayList();
			for (int i = 0; i < projects.length; i++) {
				if (projects[i] != null
					&& projects[i].getResults() != null
					&& (projectFilter == null || projectFilter.acceptProject(projects[i].getProjectId())))
					projectStatList.add(projects[i].getStatistics());
			}
			globalResults =
				ResultStatistics.merge((ResultStatistics[]) projectStatList.toArray(new ResultStatistics[0]));
			//			File indexFile = new File(runDir, "index.xml");
			//			if (indexFile.exists() && indexFile.isFile()) {
			//				// get results from index.xml
			//				StructureTree tree;
			//				try {
			//					tree = XMLTool.parseReader(new FileReader(indexFile));
			//					globalResults = new PerformResponse(tree);
			//				} catch (Exception e1) {
			//				}
			//			}
		}
		return globalResults;

	}

	public ProjectRunInterface[] getProjectsRuns() {
		return projects;
	}

	public TestDescriptionSet[] getTestDescriptionSets() {
		return testDescriptionSets;
	}

	public ProjectRunSummaryInterface[] getProjectSummaries() {
		return projects;
	}

	public String getRunRootDirectory() {
		return runDir.getAbsolutePath();
	}
}
