/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/dataprovider/ff/impl/ProjectRunSummary.java#2 $
 */

package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import java.io.File;
import java.io.FileReader;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author SAP AG d034036
 *
 */
public class ProjectRunSummary implements ProjectRunSummaryInterface {

	private static final String PROJECT_NAME = "projectName";
	private String projectName;
	private File projectDir;
	private String runId;
	private ResultStatistics statistics;

	public ProjectRunSummary(String projectName, String runId, File projectDir) {
		this.projectName = projectName;
		this.projectDir = projectDir;
		this.runId = runId;
		initializeStatistics(projectDir);
	}

	public String getProjectId() {
		return projectName;
	}

	public String getRunId() {
		return runId;
	}

	public ResultStatistics getStatistics() {
		return statistics;
	}

	private boolean initializeStatistics(File f) {
		if (f.getName().equals("statistics.xml")) {
			try {
				statistics = new ResultStatistics(XMLTool.parseReader(new FileReader(f)));
				return true;
			} catch (Exception e) {
				return false;
			}
		}
		if (f.isDirectory()) {
			File[] children = f.listFiles();
			for (int i = 0; i < children.length; i++) {
				boolean found = initializeStatistics(children[i]);
				if (found)
					return true;
			}
		}
		return false;
	}

}
