/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/report/dataprovider/ff/impl/ProjectRun.java#2 $
 */

package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author SAP AG d034036
 *
 */
public class ProjectRun implements ProjectRunInterface {

	private static final String PROJECT_NAME = "projectName";
	private String projectName;
	private Properties properties = new Properties();
	private PerformResponse[] results;
	private File projectDir;
	private String runId;
	private TestSet variant;

	public ProjectRun(String projectName, String runId, TestSet variant, File projectDir) {
		properties.setProperty(PROJECT_NAME, projectName);
		this.projectName = projectName;
		this.projectDir = projectDir;
		this.runId = runId;
		this.variant = variant;
	}

	public Properties getInfo() {
		return properties;
	}

	public PerformResponse[] getResults() {
		if (results == null) {
			if ( getIndexList(projectDir) == null)
				return new PerformResponse[0];
			results = (PerformResponse[]) getIndexList(projectDir).toArray(new PerformResponse[0]);
		}
		return results;
	}

	public ResultInterface[] getResults(String test) {
		// TODO Auto-generated method stub
		return null;
	}

 

	public TestSet getTestVariant() {
		return variant;
	}

	public PerformRequest[] getRequests() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getProjectId() {
		return projectName;
	}

	private List getIndexList(File dir) {
		if (!dir.isDirectory())
			return null;
		File index = new File(dir, "index.xml");
		if (index.exists() && index.isFile()) {
			try {
				StructureTree tree = XMLTool.parseReader(new FileReader(index));
				List out = new ArrayList();
				out.add(new PerformResponse(tree));
				return out;
			} catch (Exception e1) {
				e1.printStackTrace();
				return null;
			}
		}
		File[] childrenDirectories = dir.listFiles(new FileFilter() {
			public boolean accept(File pathname) {
				return pathname.isDirectory();
			}
		});
		List out = new ArrayList();
		for (int i = 0; i < childrenDirectories.length; i++) {
			List resp = getIndexList(childrenDirectories[i]);
			if (resp != null)
				out.addAll(resp);
		}
		if (out.size() > 0) {
			return out;
		} else {
			return null;
		}

	}

	public String getRunId() {
		return runId;
	}

	public ResultStatistics getStatistics() {
		PerformResponse[] res = getResults();
		ResultStatistics[] stats = new ResultStatistics[res.length];
		for (int i = 0; i < stats.length; i++) {
			stats[i] = new ResultStatistics(res[i].getResults());
		}
		return ResultStatistics.merge(stats);
	}

}
