/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/extension/TestSet.java#2 $
 */

package com.sap.tc.jtools.jlint.extension;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;

/**
 * @author $Author: p4trans $
 */
public class TestSet {

  private static final String TEST_SET_TAG = "testSet";
  private static final String LIB_TAG = "library";
  private static final String DESCR_TAG = "descriptorFile";
  private static final String PATH_ATTR = "path";

  protected ClassLoader loader;
  protected TestDescriptionSet descriptor;

  public TestSet(File descriptorFile, ClassLoader loader)
    throws BadTreeException, XMLParseException, IOException {
    if (!descriptorFile.isFile()) {
      throw new FileNotFoundException(
        "descriptor " + descriptorFile.getAbsolutePath() + " not found!");
    }
    descriptor = new TestDescriptionSet(descriptorFile);
    this.loader = loader;
  }

  public TestSet(StructureTree testSet, ClassLoader parent)
    throws BadTreeException, IOException, XMLParseException {
    if (!TEST_SET_TAG.equals(testSet.getTag()))
      throw new BadTreeException();
    descriptor =
      new TestDescriptionSet(new File(testSet.getParameter(DESCR_TAG)));
    StructureTree[] libs = testSet.getChildren(LIB_TAG);
    List jars = new ArrayList();
    for (int i = 0; i < libs.length; i++) {
      jars.add(new File(libs[i].getParameter(PATH_ATTR)));
    }
    loader =
      new JarClassLoader(parent, (File[]) jars.toArray(new File[0]));
  }

  public ClassLoader getLoader() {
    return loader;
  }

  public TestDescriptionSet getTestDescriptionSet() {
    return descriptor;
  }

 

}
