/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/extension/TestProviderInterface.java#2 $
 */

package com.sap.tc.jtools.jlint.extension;

import com.sap.tc.jtools.jlint.TestConflictException;
import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestSpecificationException;
import com.sap.tc.jtools.util.structures.StructureTree;

/**
 * represents a test provider.
 * 
 * A test provider provides access to test definitions and implementations.
 */
public interface TestProviderInterface {
	
	/**
	 * loads and returns the test class with the given name (if found).
	 * 
	 * The class may be loaded by an internal loader, i.e. it may be inaccessible
	 * to other components.
	 * 
	 * @return class
	 * @throws ClassNotFoundException if the class was not found
	 * 
	 */
    public Class loadTestClass(String className) throws ClassNotFoundException;
    
    /** 
     * returns the available tests
     * 
     * @return available tests
     * @throws TestConflictException 
     */
    public TestDescriptionSet getTestDescriptionSet() throws TestConflictException;
    
    public Module[] getModules();
    
    public Module getModule(String id);
    
    public TestObject getTestObject(StructureTree testObjTree) throws InvalidTestObjectSpecification;
}
