/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/extension/ModuleClassLoader.java#2 $
 */

package com.sap.tc.jtools.jlint.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/**
 * @author D037913
 */
public class ModuleClassLoader extends JarClassLoader {

	private ClassLoader[] requiredClassLoaders;

	public ModuleClassLoader(
		ClassLoader parent,
		File[] libs,
		ClassLoader[] requiredClassLoaders)
		throws IOException {
		super(parent, libs);
		this.requiredClassLoaders = requiredClassLoaders;
	}

	/* (non-Javadoc)
	 * @see java.lang.ClassLoader#findClass(java.lang.String)
	 */
	protected Class findClass(String name) throws ClassNotFoundException {
		Class c = null;
		try {
			c = super.findClass(name);
		} catch (ClassNotFoundException cnfe) {
			c = null;
		}
		if (c != null)
			return c;
		for (int i = 0; i < requiredClassLoaders.length; i++) {
			try {
				c = requiredClassLoaders[i].loadClass(name);
			} catch (ClassNotFoundException e) {
				//$JL-EXC$	 try next loader
			}

			if (c != null)
				return c;
		}
		throw new ClassNotFoundException(name);
	}

	/* (non-Javadoc)
	 * @see java.lang.ClassLoader#getResourceAsStream(java.lang.String)
	 */
	public InputStream getResourceAsStream(String name) {
		InputStream stream = super.getResourceAsStream(name);
		if (stream != null) {
			return stream;
		}
		for (int i = 0; i < requiredClassLoaders.length; i++) {
			stream = requiredClassLoaders[i].getResourceAsStream(name);
			if (stream != null)
				return stream;
		}
		return null;
	}

}
