/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/TestVariantList.java#2 $
 */

package com.sap.tc.jtools.jlint;

/**
 * linked list of TestVariant.
 */

class TestVariantList implements java.io.Serializable{

    public TestVariant first;
    public TestVariantList next;

    public TestVariantList() {
        first = null;
        next = null;
    }

    public TestVariantList(TestVariant variant) {
        first = variant;
        next = null;
    }

    public void addLast(TestVariant inLast) {
        if ( first == null ) {
            first = inLast;
            return;
        }
        TestVariantList current = this;
        while ( current.next != null ) {
            current = current.next;
        }
        current.next = new TestVariantList(inLast);
        return;
    }

    public void addFirst(TestVariant inFirst) {
        if ( first == null ) {
            first = inFirst;
            return;
        }

        TestVariantList temp = new TestVariantList();
        temp.first = first;
        temp.next = next;
        first = inFirst;
        next = temp;
        return;
    }

    public TestVariant search(TestVariant variant) {
        if ( first == null ) {
            return null;
        }
        if ( ( first.getTestDefinition().getName().equals(variant.getTestDefinition().getName()) )
             && ( ( ( first.getParameters() == null )
                    && ( variant.getParameters() == null )
                  )
                  || (  first.getParameters().equals(variant.getParameters()) )
                )
           ){
            return first;
        }
        if ( next != null) {
            return next.search(variant);
        }
        return null;
    }
}