/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/TestVariant.java#3 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jlint.exceptions.*;

/**
 * each instance represents a fully defined test (complete with
 * parameters and messages) - used internally
 */

class TestVariant {

	private TestDefinition testDefinition;
	private ParameterInterface[] parameters;
	private ITestMessageDescription[] messages;
	private com.sap.tc.jtools.jtci.TestObject testObject;

	public TestVariant(
		TestDefinition testDefinition,
		ParameterInterface[] parameters,
		ITestMessageDescription[] messages,
    com.sap.tc.jtools.jtci.TestObject testObject)
		throws InvalidDataProviderException {
		this.testDefinition = testDefinition;
		this.parameters = parameters;
		this.messages = messages;
		this.testObject = testObject;
	}

	public String getName() {
		return testDefinition.getTestClass();
	}

	public ParameterInterface[] getParameters() {
		return parameters;
	}

	public ITestMessageDescription[] getMessages() {
    return messages;	  
	}

	public com.sap.tc.jtools.jtci.TestObject getTestObject() {
		return testObject;
	}

	public TestDefinition getTestDefinition() {
		return testDefinition;
	}

}