/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/TestProcessorInterface.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;

/**
 *  Interface implemented by test processors.
 */
public interface TestProcessorInterface extends ProcessorInterface {

	/**
	 * returns the error messages produced by the tests managed by the test processor.
	 * 
	 * @return errors
	 */
	public ResultInterface[] getErrors();

	/**
	 * returns the tested object .
	 * 
	 * @return test object
	 */
	public TestObject getTestObject();

} 