/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/TestDescriptionSet.java#2 $
 */

package com.sap.tc.jtools.jlint;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.persistable.Persistable;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * @author d034036
 */
public class TestDescriptionSet implements Persistable {

  private static final String CUR_DIR_MACRO = "CURRENT_DIRECTORY";
  private static final String PARAMETER_TAG_TOOL_DESCRIPTOR = "TOOL_DESCRIPTOR"; //$NON-NLS-1$
  private static final String TOOL_VERSION = "VERSION"; //$NON-NLS-1$
  private static final String TOOL_NAME = "NAME"; //$NON-NLS-1$
  private int version;
  private String name;
  private TestTree testTree;

  public TestDescriptionSet(String name, int version, TestTree testTree) {
    this.version = version;
    this.name = name;
    this.testTree = testTree;
  }

  public TestDescriptionSet(File file)
    throws IOException, XMLParseException, BadTreeException {
    StructureTree testTree =
      XMLTool.parseReader(new BufferedReader(new FileReader(file)));
    // resolve macros
    Properties macros = new Properties();
    macros.setProperty(CUR_DIR_MACRO, file.getParentFile().getAbsolutePath()); //$NON-NLS-1$
    testTree.resolveMacros(macros);
    init(testTree);
  }

  private void init(StructureTree tree) throws BadTreeException {
    try {
      name = tree.getParameter(TOOL_NAME);
      version = Integer.parseInt(tree.getParameter(TOOL_VERSION));
      testTree = new TestTree(tree.getChildren()[0]);
    } catch (Exception e) {
      throw new BadTreeException(e);
    }
  }

  public TestDescriptionSet(StructureTree tree) throws BadTreeException {
    init(tree);
  }
  

  public int getVersion() {
    return version;
  }

  public String getName() {
    return name;
  }

  public TestTree getTestTree()  {
    try {
		return  new TestTree(testTree.toStructureTree()); //easiest way to clone
	} catch (BadTreeException e) {
		return null; //cant happen
	} 
  }

  public StructureTree toStructureTree() {
    Header header = new Header(PARAMETER_TAG_TOOL_DESCRIPTOR);
    header.setParameter(TOOL_NAME, name);
    header.setParameter(TOOL_VERSION, String.valueOf(version));
    StructureTree st = new StructureTree(header);
    st.addChild(testTree.toStructureTree());
    return st;
  }
/*
  public void mergeWithTestDescriptionSet(TestDescriptionSet tds)
    throws TestConflictException {
    TestDescriptionInterface[] tests1 = this.getTestTree().getAllLeaves();
    TestDescriptionInterface[] tests2 = tds.getTestTree().getAllLeaves();
    for (int i = 0; i < tests1.length; i++) {
      for (int j = 0; j < tests2.length; j++) {
        if (tests1[i].getName().equals(tests2[j].getName())) {
          throw new TestConflictException("test " + tests1[i].getName() + " exists already!"); //$NON-NLS-1$ //$NON-NLS-2$
        }
      }
    }
    this.getTestTree().addTree(tds.getTestTree());
  }
*/
/*  public void mergeWithTestDescriptionSet(File file)
    throws TestConflictException, BadTreeException, IOException, XMLParseException {
    mergeWithTestDescriptionSet(new TestDescriptionSet(file));
  } */
}
