/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/TestComponentInterface.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jtci.TestObject;

/**
 * represents a test processor subcomponent.
 * 
 * It is implemented by all test classes
 */

public interface TestComponentInterface extends ProcessorUnitInterface {
	
	/**
	 * sets parameters and test object
	 * 
	 * @param parameters test parameters
	 * @param testObject object to be tested 
	 * 
	 */
    public void setParameters(ParameterInterface[] parameters, TestObject testObject);
    
	/**
	 * method used to convert (if necessary) raw results into final ones.
	 * This method can be used e.g. for averaging, extracting global properties, etc. 
	 * 
	 * @param rw raw results
	 * @return processed results (<code>null</code> if no processing required) 
	 * 
	 */    
    public ResultInterface[] processErrors(ResultInterface[] rw);
    
    /** internal use */
    
    public void setInternalParameters(ParameterInterface[] params);

    public void setMessages(ITestMessageDescription[] messages);
}