/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/ResultWrapper.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jtci.exceptions.*;
import com.sap.tc.jtools.util.persistable.*;
import com.sap.tc.jtools.util.structures.*;

/**
 * represents a set of results  
 *
 */

public class ResultWrapper implements Persistable {

	/* XML representation */
	private final static String PARAMETER_TAG_RESULT_WRAPPER = "RESULT_WRAPPER"; //$NON-NLS-1$
	private final static String PARAMETER_TAG_RESULT = "RESULT"; //$NON-NLS-1$

	private Result[] results;

	/** 
	 * standard constructor
	 * 
	 * @param res result array 
	 */
	public ResultWrapper(Result[] res) {
		results = res;
	}

	/** 
	 * constructor used to reconstruct a persisted result set
	 * 
	 * @param tree object in persistable form
	 */
	public ResultWrapper(StructureTree tree) throws BadTreeException {
		StructureTree[] trees = tree.getChildren(PARAMETER_TAG_RESULT);
		results = new Result[trees.length];
		for (int i = 0; i < trees.length; i++)
			results[i] = new Result(trees[i]);
	}

	/** 
	 * returns the results
	 * 
	 * @return result array
	 */
	public ResultInterface[] getResults() {
		return results;
	}

	/**
	 * returns the persistable form of this object
	 * 
	 * @return structure tree
	 * 
	 */
	public StructureTree toStructureTree() {
		StructureTree root =
			new StructureTree(new Header(PARAMETER_TAG_RESULT_WRAPPER));
		for (int i = 0; i < results.length; i++)
			root.addNewChild(results[i].toStructureTree());
		return root;
	}

}