/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/Result.java#3 $
 */

package com.sap.tc.jtools.jlint;

import java.util.Enumeration;
import java.util.Properties;

import com.sap.tc.jtools.util.structures.*;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jtci.*;

/**
 * implements ResultInterface.  
 */

public class Result implements ResultInterface {

	static public final String PARAMETER_TAG_ERROR_MESSAGE = "MESSAGE"; //$NON-NLS-1$

	static public final String ERROR_MESSAGE_COULDNT_PERFORM = "Couldnt_perform"; //$NON-NLS-1$
	static public final String ERROR_MESSAGE_JOB_CANCELED = "job_canceled"; //$NON-NLS-1$
	static public final String ERROR_MESSAGE_MISSING_DATA = "Missing_data"; //$NON-NLS-1$
	static public final String ERROR_MESSAGE_SYNTAX_ERROR = "syntax_error"; //$NON-NLS-1$
	static public final String RESULT_PRIORITY = "PR"; //$NON-NLS-1$
	private String testName;

	private String testObjectType;
	private String testObjectID;
	private TestObjectPosition resultPosition;
	private int priority;
	private StructureTree errorMessageTree;

	public Result(
		String testName,
		String testObjectType,
		String testObjectID,
		TestObjectPosition position,
		int priority,
		String errorMessage,
		Properties errorMessageParameters) {
		this.testName = testName;
		this.testObjectType = testObjectType;
		this.testObjectID = testObjectID;
		this.priority = priority;
		this.resultPosition = position;

		Header messageHeader = new Header(PARAMETER_TAG_ERROR_MESSAGE);
		messageHeader.setParameter(
			RESULT_PRIORITY,
			Integer.toString(priority));
    	errorMessageTree = new StructureTree(messageHeader);
		if (errorMessageParameters != null) {
			setParameters(errorMessageParameters);
		}
		errorMessageTree.setText(errorMessage);
	}

	public Result(StructureTree tree) throws BadTreeException {
		try { //todo finish
			testName = tree.getOnlyChild("TEST").getParameter("NAME");
			priority = Integer.parseInt(tree.getParameter(RESULT_PRIORITY));
			errorMessageTree = tree.getOnlyChild("EM");
		} catch (Exception e) {
			throw new BadTreeException(e);
		}
	}

	public String getTestName() {
		return testName;
	}

	public String getTestObjectID() {
		return testObjectID;
	}

	public String getTestObjectType() {
		return testObjectType;
	}

	public TestObjectPosition getResultPosition() {
		return resultPosition;
	}

	public String getErrorText() {
		return errorMessageTree.getText();
	}
  
  public void setErrorText(String text) {
    errorMessageTree.setText(text);
  }
	
	public Properties getErrorParameters() {
		return errorMessageTree.getParameters();
	}

    public void setParameters(Properties errorMessageParameters){
		Enumeration keys = errorMessageParameters.keys();
		while (keys.hasMoreElements()) {
			String key = (String) keys.nextElement();
			Header messageHeader = errorMessageTree.getHeader();
			messageHeader.setParameter(
				key,
				errorMessageParameters.getProperty(key));
		}    	
    }
    
	public int getPriority() {
		return priority;
	}

	public StructureTree toStructureTree() {

		String testObjectType = getTestObjectType();

		String thisSourceID = getTestObjectID();
		Header sourceHeader = new Header("SOURCE");
		sourceHeader.setParameter("ID", thisSourceID);
		sourceHeader.setParameter("TYPE", testObjectType);
		StructureTree sourceTree = new StructureTree(sourceHeader);


		String testName = getTestName();
		Header testHeader = new Header("TEST");
		testHeader.setParameter("NAME", testName);

		StructureTree testTree = new StructureTree(testHeader);
		sourceTree.addNewChild(testTree);

		testTree.addNewChild(errorMessageTree);		
		
		TestObjectPosition position = getResultPosition();
		if (position != null) {		
		    errorMessageTree.addChild(position.toStructureTree());
		}
		
//		if (testObjectType.equals(TestObject.JAVA_FILE_LIST)) {			
//			JavaFileArrayTestObject.FilePosition position =
//				(JavaFileArrayTestObject.FilePosition) getResultPosition();
//			if (position != null) {
/*				Header fileHeader = new Header("FILE");
				fileHeader.setParameter("NAME", position.getFile());
				StructureTree fileTree = new StructureTree(fileHeader);
				sourceTree.addChild(fileTree);
				currentTree = fileTree;
				int line = position.getLine();
				int column = position.getColumn();
				if (line != -1 || column != -1) {
					Header filePositionHeader = new Header("FILE_POSITION");
					if (line != -1)
						filePositionHeader.setParameter(
							"LINE",
							Integer.toString(line));
					if (column != -1)
						filePositionHeader.setParameter(
							"COLUMN",
							Integer.toString(column));
					StructureTree filePositionTree =
						new StructureTree(filePositionHeader);
					fileTree.addChild(filePositionTree);
					currentTree = filePositionTree;
				}
//			}
//		}
/*		String testName = getTestName();
		Header testHeader = new Header("TEST");
		testHeader.setParameter("NAME", testName);

		StructureTree testTree = new StructureTree(testHeader);
		currentTree.addChild(testTree);

		testTree.addNewChild(errorMessageTree); */
		return sourceTree;
	}
}
