/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/RequirementInterface.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;

/**
 * Interface representing a requirement (data structure required by 
 * a processor).
 * <p>
 * Requirements are identified by the following properties:
 * <ul>
 * <li> class name</li>
 * <li> parameters </li>
 * </ul> 
 * 
 * <p>
 * Each requirement instance is computed by its associated processor.
 * 
 * 
 * Copyright (c) 2003, SAP AG
 * 
 */

public interface RequirementInterface {

	/**
	 *  used as the conventional class name for external files
	 * 
	 */	
	public String REQUIREMENT_EXTERNAL_FILE = "External file"; //$NON-NLS-1$
		
	/**
	 *  returns the class name of the required data structure.
	 * 
	 * 
	 * @return class name
	 * 
	 */	
    public String getClassName();

	/**
	 *  returns the parameters of the required data structure.
	 * 
	 * 
	 * @return parameters 
	 * 
	 */	    
    public ParameterInterface[] getParameters();
    
	/**
	 * returns the processor instance responsible for providing the 
	 * required data structure.
	 * 
	 * @return processor
	 * 
	 */    
    public ProcessorInterface getProcessor();
}