/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/Requirement.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;


/**
 * implements RequirementInterface. 
 * 
 * This class is subclassed by the concrete - typically anonymous - classes 
 * representing processor requirements
 * 
 */
abstract public class Requirement implements RequirementInterface {

  private String className;
  private ParameterInterface[] parameters;

  /**
   * constructor
   * 
   * @param className required processor's class name
   * @param parameters required processor's parameters
   * 
   */
  public Requirement(String className, ParameterInterface[] parameters) {
      this.className = className;
      this.parameters = parameters;
  }


  public String getClassName() {
      return className;
  }

  public ParameterInterface[] getParameters() {
      return parameters;
  }
 
}