/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/ProcessorUnitInterface.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;

/**
 * represents a processor unit (i.e. a subcomponent)
 * 
 * Copyright (c) 2003, SAP AG
 * 
 */

public interface ProcessorUnitInterface {
	
	/**
	 * returns the processor unit class name
	 * 
	 * @return class name
	 */
	public String getName();
	
	/**
	 * returns the parameters (names and values) of this processor unit instance
	 * 
	 * @return instance parameters
	 */
	public ParameterInterface[] getParameters();
	
	/**
	 * returns the definition of the processor this unit belongs to
	 * 
	 * @return processor definition
	 */
	public RequirementInterface getProcessorDefinition();
	
	/**
	 * returns the role this unit plays inside the processor
	 * 
	 * @return role
	 */
	public String getRole();
	
	/**
	 * sets the processor instance the unit belongs to
	 * 
	 * @param processor
	 */	
	public void setProcessor(ProcessorInterface processor);
	

}