/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/ProcessorUnitFactory.java#3 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jlint.exceptions.*;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;

/**
 * class used to instantiate test components (internal use only).
 * 
 */

public class ProcessorUnitFactory {

  private static TestProviderInterface testProvider;

  /**
   * returns an instance of the test component class with the given name
   * 
   * @param name class name
   * @return instance of the test component class  
   * @throws InvalidDataProviderException if the class does not exist, 
   * is not a processor unit class, or for any reason cannot be instantiated 
   * 
   */
  static public TestComponentInterface createTestComponent(TestDescriptionInterface testDescription)
    throws InvalidDataProviderException {
    String className =
      (String) testDescription
        .getInternalParameter(TestDefinition.PARAMETER_TEST_CLASS)
        .getValue();
    Class diClass = null;
    try {
      if (testProvider != null) {
        diClass = testProvider.loadTestClass(className);
      } else {
        diClass = Class.forName(className);
      }
    } catch (Exception e) {
      throw new NonexistentDataClassException("Testclass is unknown: " + className, e); //$NON-NLS-1$ 
    }
    TestComponentInterface di = null;
    try {
      di = (TestComponentInterface) diClass.newInstance();
    } catch (Exception e) {
      throw new com.sap.tc.jtools.jlint.exceptions.IllegalParameterException("Cannot instantiate class: " + className, e); //$NON-NLS-1$
    }
    di.setInternalParameters(testDescription.getInternalParameters());
    return di;
  }

  /**
   * Method setExtensionManager.
   * @param manager
   */
  public static void setTestProvider(TestProviderInterface manager) {
    testProvider = manager;
  }

}