/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/ProcessorInterface.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.interfaces.*;
import com.sap.tc.jtools.jlint.exceptions.*;

/**
 * Interface implemented by processors.
 * <p>
 * Processors are component that deliver data structures that
 * are required to execute the tests.
 * <p>
 * Processor instances are uniquely identified by:
 * <ul>
 * <li> processor name (identical with the name of the implementing class)</li>
 * <li> processor parameters </li>
 * </ul> 
 * 
 * <p>
 * Processors may in turn require other data structures ("prerequisites"). This
 * prerequisites are specified by "requirements (objects implementing the interface
 * com.sap.tc.jtools.jlint.RequirementInterface).
 * 
 * 
 * 
 * Copyright (c) 2003, SAP AG
 * 
 */

public interface ProcessorInterface {

	/**
	 * sets a listener that will be called after processing each
	 * testobject component
	 */
	public void setListener(Listener listener);

	/**
	 *  Returns the processor name.
	 * 
	 * 
	 * @return processor name
	 * 
	 */
	public String getName();

	/**
	 *  Returns the processor parameters.
	 * 
	 * 
	 * @return processor parameters
	 * 
	 */
	public ParameterInterface[] getParameters();

	/**
	 *  executes the data computation.
	 * 
	 * 
	 * @throws ExecutionException if something goes wrong
	 * 
	 */
	public void execute() throws ExecutionException;

	/**
	 *  returns the computed data.
	 * 
	 * 
	 * @return data
	 * 
	 */
	public Object getData();

	/**
	 *  adds processor unit.
	 * 
	 * 
	 * @param processorUnit processor unit to be added
	 * @param role processor unit role
	 * 
	 */
	public void addProcessorUnit(
		ProcessorUnitInterface processorUnit,
		String role);

	/**
	 *  returns processor requirements.
	 * 
	 * 
	 * @return processor requirements
	 * 
	 */
	public RequirementInterface[] getRequirements();

	/**
	 *  sets prerequisites.
	 * 
	 * 
	 * @param values prerequisites
	 * 
	 */
	public void setPrerequisites(Object[] values);
	
	/* commonly used processor parameters */
	public String PARAMETER_TARGET_FILE_LIST = "Target file list"; //$NON-NLS-1$
	public String PARAMETER_TARGET_FILE = "Target file"; //$NON-NLS-1$
}