/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/Main.java#3 $
 */

package com.sap.tc.jtools.jlint;

import java.io.File;
import java.io.FileReader;

import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jtci.Dispatcher;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;

/**
 * This class can be used as an entry point for debugging 
 * JLin tests.
 *  
 * Copyright (c) 2003, SAP AG
 */

public class Main {

  /**
   * @param args: arg[0] config file
   *              arg[1] filename of an xml-file 
   *                     representing a PerformRequest 
   */

  public static void main(String[] args) {
    if (args.length != 2){
      printHelp();
      System.exit(1);
    }
    File configFile = new File(args[0]);
    File requestFile = new File(args[1]);
    run(configFile, requestFile);
  }

  private static void printHelp() {
    System.out.println(
      "Usage: "
        + Main.class.getName()
        + " <config_file.xml> <request_file.xml>");
  }

  private static void run(
    File configFile,
    File requestFile) {
    try {
      PerformRequest request = null;
      Dispatcher dispatcher =
        new Dispatcher(TestProvider.initialize(configFile));
      request =
        new PerformRequest(XMLTool.parseReader(new FileReader(requestFile)));
      PerformResponse response = dispatcher.processRequest(request);
      System.out.println("JLin found " + response.getResults().length + " errors:\n"); //$NON-NLS-1$ //$NON-NLS-2$
      StructureTree responseTree = response.toStructureTree();
      System.out.println(XMLTool.toString(responseTree));
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}