/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_core/src/com/sap/tc/jtools/jlint/ExternalFileRequirement.java#2 $
 */

package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;

/**
 * @author I024087 Denitsa Evtimova
 */
public class ExternalFileRequirement implements RequirementInterface {

  private ParameterInterface[] params;

  public ExternalFileRequirement(String fileName) {
    params = new ParameterInterface[1];
    params[0] =
      ParameterTool.createParameter(
        ProcessorInterface.PARAMETER_TARGET_FILE,
        ParameterTool.PAR_TYPE_STRING,
        fileName);
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getClassName()
   */
  public String getClassName() {
    return REQUIREMENT_EXTERNAL_FILE;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getParameters()
   */
  public ParameterInterface[] getParameters() {
    return params;
  }

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.RequirementInterface#getProcessor()
   */
  public ProcessorInterface getProcessor() {
    return null;
  }

}
