/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault_Exception.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.dynamicrfc;

import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.modelimpl.dynamicrfc.WDDynamicRFC_Fault.NameType;

/**
 * Title:        Web Dynpro Dynamic RFC Adapter Exception
 * Description:
 * Copyright:    Copyright (c) 2003
 * Company:      SAP AG
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault_Exception.java#1 $
 */
public class WDDynamicRFC_Fault_Exception extends com.sap.aii.proxy.framework.core.ApplicationFaultException implements java.io.Serializable   {

	private static final Location logger = Location.getLocation(WDDynamicRFC_Fault_Exception.class.getName());
	static {
		Location.getLocation("ID.com.sap.tc.webdynpro.modelimpl.dynamicrfc").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFC_Fault_Exception.java#1 $");
	}

	private static final long serialVersionUID = -1731708704L;

	public void setWDDynamicRFC_Fault(
		WDDynamicRFC_Fault fault) {
		this.fault = fault;
	}

	public WDDynamicRFC_Fault getWDDynamicRFC_Fault() {
		return (
			WDDynamicRFC_Fault) fault;
	}

	public java.lang.String getFaultName() {
		if (fault == null)
			return null;
		NameType nameType = getWDDynamicRFC_Fault().getName();
		if (nameType == null)
			return null;
		return nameType.getValue();
	}

	public java.lang.String getFaultText() {
		if (fault == null)
			return null;
		return getWDDynamicRFC_Fault().getText();
	}
}
