/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCExecuteException.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.dynamicrfc;

import com.sap.aii.proxy.framework.core.BaseType;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.modelimpl.dynamicrfc.WDDynamicRFC_Fault.NameType;
import com.sap.tc.webdynpro.modelimpl.rfcadapter.WDExecuteRFCException;

/**
 * Title:        Web Dynpro Dynamic RFC Adapter Exception
 * Description:
 * Copyright:    Copyright (c) 2003
 * Company:      SAP AG
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCExecuteException.java#1 $
 */
public class WDDynamicRFCExecuteException extends WDExecuteRFCException
{

	private static final Location logger = Location.getLocation(WDDynamicRFCExecuteException.class.getName());
	static {
		Location.getLocation("ID.com.sap.tc.webdynpro.modelimpl.dynamicrfc").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCExecuteException.java#1 $");
	}
  /**
   * Creates a web dynpro RFC Execution exception
   * @param messageText
   */
  public WDDynamicRFCExecuteException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   * @param messageText
   * @param reason
   */
  public WDDynamicRFCExecuteException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   * @param reason
   */
  public WDDynamicRFCExecuteException(Throwable reason) {
    this(null, null, reason);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   * @param messageText
   * @param parameters
   */
  public WDDynamicRFCExecuteException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro RFC Execution exception
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDDynamicRFCExecuteException(String messageText, Object[] parameters, Throwable reason)
  {
    super(messageText, parameters, reason);
  }

  /**
   * Returns the expanded message text of the fault returned by the backend.
   */
  public String getMessage()
  {
		BaseType fault = getFault();
		if((fault != null ) && (fault instanceof WDDynamicRFC_Fault ))
		{
			NameType nameType = ((WDDynamicRFC_Fault)fault).getName();
			if (nameType == null)
				return super.getMessage();
			String msg = nameType.getValue();
			if (msg == null || "".equals(msg))
				return super.getMessage();
			return msg;
		}
		return super.getMessage();
  }

  /**
   * Returns the object carrying the fault information resulting from the exception raised in the backend.
   *
   * the returned object must be cast to the appropriate FaultType to access specific Fault properties.
   */
  public BaseType getFault()
  {
		return super.getFault();
  }

	/**
	 * Returns the object carrying the fault information resulting from the exception raised in the backend.
	 *
	 */
	public WDDynamicRFC_Fault getWDDynamicRFC_Fault()
	{
		BaseType fault = getFault();
		if((fault != null ) && (fault instanceof WDDynamicRFC_Fault ))
			return (WDDynamicRFC_Fault)fault;
		return null;
	}
}
