/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCException.java#1 $
 */
package com.sap.tc.webdynpro.modelimpl.dynamicrfc;

import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.modelimpl.rfcadapter.WDRFCException;

/**
 * Title:        Web Dynpro Dynamic RFC Adapter Exception
 * Description:
 * Copyright:    Copyright (c) 2003
 * Company:      SAP AG
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCException.java#1 $
 */
public class WDDynamicRFCException extends WDRFCException
{

	private static final Location logger = Location.getLocation(WDDynamicRFCException.class.getName());
	static {
		Location.getLocation("ID.com.sap.tc.webdynpro.modelimpl.dynamicrfc").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_model_dynamicrfc/java/com/sap/tc/webdynpro/modelimpl/dynamicrfc/WDDynamicRFCException.java#1 $");
	}

  public static final String DYNAMICRFCMODELCLASS_LIST_WRONG_ELEMENT_TYPE = "List must contain AbstractList (ProxyList) of Type '{0}', not of '{1}'!";
	public static final String DYNAMICRFCMODELCLASS_WRONG_RELATION_TYPE = "The Relation must reference ModelClass instances of Type '{0}', not of '{1}'!";
  /**
   * Creates a web dynpro RFC Execution exception
   */
  public WDDynamicRFCException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro RFC exception
   */
  public WDDynamicRFCException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro RFC exception
   */
  public WDDynamicRFCException(Throwable reason) {
    this(null, null, reason);
  }

  /**
   * Creates a web dynpro RFC exception
   */
  public WDDynamicRFCException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro RFC exception
   */
  public WDDynamicRFCException(String messageText, Object[] parameters, Throwable reason)
  {
    super(messageText, parameters, reason);
  }

}
