/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/operands/StringOperandType.java#1 $
 */

package com.sapportals.wcm.service.relation.operands;

import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.InvalidArgumentException;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.service.relation.IRelationOperand;
import com.sapportals.wcm.service.relation.IRelationOperandType;

/**
 * <code>IRelationOperandType</code> implementation for <code>String</code> s.
 * <br>
 *
 */
public class StringOperandType
   implements IRelationOperandType {

  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  /**
   * Create a <code>String</code> operand type.
   */
  public StringOperandType() { }


  // ------
  // Object -------------------------------------------------------------------
  // ------

  // ------------------------------------------------------------------------
  public boolean equals(Object object) {

    if (object instanceof StringOperandType) {
      return true;
    }
    return false;
  }


  // --------------------
  // IRelationOperandType -----------------------------------------------------
  // --------------------

  // ------------------------------------------------------------------------
  public boolean isDeleteTrackingSupported() {

    return false;// can't determine if a string still exists

  }


  // ------------------------------------------------------------------------
  public boolean isChangeTrackingSupported() {

    return false;// can't determine if a string did change

  }


  // ------------------------------------------------------------------------
  public boolean isCopyTrackingSupported() {

    return false;// can't determine if a string was copied

  }


  // ------------------------------------------------------------------------
  public boolean check(IRelationOperand operand)
    throws ResourceException {

    if (operand == null) {
      return false;// unable to check null
    }

    IRelationOperandType operandType = operand.getType();
    if (!(operandType instanceof StringOperandType)) {
      return false;// unable to check other implementations
    }

    return true;
  }


  // ------------------------------------------------------------------------
  public IRelationOperand getOperand(String id,
    IResourceContext context)
    throws InvalidArgumentException {

    if (id == null) {
      throw new InvalidArgumentException("<null> not allowed as id");
    }

    return new StringOperand(id);
  }


  // ------------------------------------------------------------------------
  public IRelationOperand getOperand(Object object)
    throws InvalidArgumentException {

    if (object == null) {
      throw new InvalidArgumentException("<null> not allowed");
    }

    if (!(object instanceof String)) {
      throw new InvalidArgumentException("class " + object.getClass().getName() + " not supported as StringOperand");
    }

    return new StringOperand((String)object);
  }

}
