/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/operands/StringOperand.java#2 $
 */

package com.sapportals.wcm.service.relation.operands;
import com.sapportals.wcm.repository.IResource;

import com.sapportals.wcm.repository.InvalidArgumentException;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.service.relation.IRelationOperand;
import com.sapportals.wcm.service.relation.IRelationOperandType;

/**
 * <code>IRelationOperand</code> implementation for <code>String</code> s. <br>
 *
 */
public class StringOperand
   extends AbstractRelationOperand {

  // ----------------
  // Static Variables ---------------------------------------------------------
  // ----------------

  private static StringOperandType type = new StringOperandType();

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private String string;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  /**
   * Create a <code>StringOperand</code> out of a <code>String</code> .
   *
   * @param string the <code>String</code> to wrap.
   * @throws InvalidArgumentException , if the given string is
   *      <code>null</code> .
   */
  public StringOperand(String string)
    throws InvalidArgumentException {

    if (string == null) {
      throw new InvalidArgumentException("<null> string not allowed");
    }

    this.string = string;

  }


  // --------------
  // Public Methods -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  /**
   * Get the wrapped string.
   *
   * @return the <code>String</code> for this operand.
   */
  public String getValue() {

    return this.string;
  }


  // ------
  // Object -------------------------------------------------------------------
  // ------

  // ------------------------------------------------------------------------
  public boolean equals(Object object) {

    if (object instanceof StringOperand) {
      StringOperand operand = (StringOperand)object;
      return (this.string.equals(operand.string));
    }
    return false;
  }


  // ----------------
  // IRelationOperand ---------------------------------------------------------
  // ----------------

  // ------------------------------------------------------------------------
  public IRelationOperandType getType()
    throws ResourceException {

    return StringOperand.type;
  }


  // ------------------------------------------------------------------------
  public String getID()
    throws ResourceException {

    return this.string;
  }


  // ------------------------------------------------------------------------
  public Object getObject() {

    return this.string;
  }


  // ------------------------------------------------------------------------
  public IResource asResource()
    throws ResourceException {

    return null;
  }

}
