/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.relation.operands;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.InvalidArgumentException;

import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.service.relation.*;

import java.util.Properties;

/**
 * The internal interface for a <code>IRelation</code> s operand for the
 * relation manager. <br>
 * This interface defines the methods to be used by the relation manager for
 * storing or retrieving additional informations for a relation operand.
 */
public interface IRelationOperandTypeExtended
   extends IRelationOperandType {

  /**
   * Get the operand for a given id, context and the stored properties from the
   * relation manager.
   *
   * @param id the <code>String</code> with the unique id of the operand to get.
   * @param context the <code>IResouceContext</code> to use for retrieving the
   *      operand.
   * @param properties the <code>Properties</code> stored in the relation
   *      manager for this operand.
   * @return the <code>IRelationOperandExtended</code> for the given id.
   * @throws InvalidArgumentException if the id is <code>null
   *      </code>.
   * @throws ResourceException if there was an error while
   *      retrieving the operand.
   */
  public IRelationOperandExtended getOperand(String id,
    IResourceContext context,
    Properties properties)
    throws InvalidArgumentException,
    ResourceException;

}
