/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.service.relation.operands;
import com.sapportals.wcm.repository.AccessDeniedException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.IResourceContext;

import com.sapportals.wcm.repository.InvalidArgumentException;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.service.relation.*;

/**
 * A basic <code>IRelationOperand</code> implementation which handles the <code>
 * getRelation</code> ...<code>()</code> methods. <br>
 *
 */
public abstract class AbstractRelationOperand
   implements IRelationOperand {

  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  public AbstractRelationOperand() { }


  // ----------------
  // IRelationOperand ---------------------------------------------------------
  // ----------------

  // ------------------------------------------------------------------------
  public abstract IRelationOperandType getType()
    throws ResourceException;


  // ------------------------------------------------------------------------
  public abstract String getID()
    throws ResourceException;


  // ------------------------------------------------------------------------
  public abstract Object getObject();


  // ------------------------------------------------------------------------
  public abstract IResource asResource()
    throws ResourceException;


  // ------------------------------------------------------------------------
  public IRelationList getRelationsBySource(IResourceContext context)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    return RelationServiceFactory.getInstance().getRelationsBySource(context, this);
  }


  // ------------------------------------------------------------------------
  public IRelationList getRelationsBySource(IRelationType type)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    if (type == null) {
      throw new InvalidArgumentException("type <null> not allowed");
    }
    return type.getRelationsBySource(this);
  }


  // ------------------------------------------------------------------------
  public IRelationList getRelationsBySource(IResourceContext context,
    IRelationOperand target)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    return RelationServiceFactory.getInstance().getRelations(context, this, target);
  }


  // ------------------------------------------------------------------------
  public IRelation getRelationBySource(IRelationType type,
    IRelationOperand target)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {
    if (type == null) {
      throw new InvalidArgumentException("type <null> not allowed");
    }

    return type.getRelation(this, target);
  }


  // ------------------------------------------------------------------------
  public IRelationList getRelationsByTarget(IResourceContext context)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    return RelationServiceFactory.getInstance().getRelationsByTarget(context, this);
  }


  // ------------------------------------------------------------------------
  public IRelationList getRelationsByTarget(IRelationType type)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    if (type == null) {
      throw new InvalidArgumentException("type <null> not allowed");
    }

    return type.getRelationsByTarget(this);
  }


  // ------------------------------------------------------------------------
  public IRelationList getRelationsByTarget(IResourceContext context,
    IRelationOperand source)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    return RelationServiceFactory.getInstance().getRelations(context, source, this);
  }


  // ------------------------------------------------------------------------
  public IRelation getRelationByTarget(IRelationType type,
    IRelationOperand source)
    throws InvalidArgumentException,
    AccessDeniedException,
    ResourceException {

    if (type == null) {
      throw new InvalidArgumentException("type <null> not allowed");
    }

    return type.getRelation(source, this);
  }

}
