/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/RelationServiceFactory.java#2 $
 */

package com.sapportals.wcm.service.relation;
import com.sapportals.wcm.repository.IResourceFactory;
import com.sapportals.wcm.repository.ResourceException;

import com.sapportals.wcm.repository.ResourceFactory;
import com.sapportals.wcm.service.IServiceFactory;
import com.sapportals.wcm.service.IServiceTypesConst;

/**
 * The relation service factory. <br>
 *
 */
public class RelationServiceFactory {

  // ----------------
  // Static Variables ---------------------------------------------------------
  // ----------------

  private static IRelationService instance = null;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  private RelationServiceFactory() { }


  // --------------
  // Static Methods -----------------------------------------------------------
  // --------------

  // ------------------------------------------------------------------------
  /**
   * Get an instance of the relation service.
   *
   * @return a <code>IRelationService</code> -instance.
   * @throws ResourceException if there was an internal error
   *      while getting the instance of the <code>RelationService</code> .
   */
  public static IRelationService getInstance()
    throws ResourceException {

    if (RelationServiceFactory.instance == null) {
      synchronized (RelationServiceFactory.class) {
        if (RelationServiceFactory.instance == null) {
          RelationServiceFactory.instance = (IRelationService)ResourceFactory.getInstance().getServiceFactory().getService(IServiceTypesConst.RELATION_SERVICE);
        }
      }
    }

    return RelationServiceFactory.instance;
  }

}
