/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/RelationQueryException.java#1 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.WcmException;

/**
 * An exception concerning the <code>IRelationQueryBuilder</code> . <br>
 *
 */
public class RelationQueryException
   extends WcmException {

  // ------------------------------------------------------------------------
  /**
   * Creates a relation query exception with an additional message.
   *
   * @param message a <code>String</code> with the exception's message
   */
  public RelationQueryException(String message) {

    super(message);

  }


  // ------------------------------------------------------------------------
  /**
   * Creates a relation query exception with defined logging settings.
   *
   * @param log a <code>boolean</code> <b>false</b> if no logging is to be done.
   */
  public RelationQueryException(boolean log) {

    super(log);

  }

}
