/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/OrderedRelationPosition.java#1 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.repository.enum.OrderPosition;

/**
 * An implementation for the ordering position for relations. <br>
 * Not yet supported!
 */
public class OrderedRelationPosition
   implements IOrderedRelationPosition {

  // ---------
  // Constants ----------------------------------------------------------------
  // ---------

  /**
   * A position indicating the first entry.
   */
  public final static OrderedRelationPosition FIRST = new OrderedRelationPosition(null, OrderPosition.FIRST);

  /**
   * A position indicating the last entry.
   */
  public final static OrderedRelationPosition LAST = new OrderedRelationPosition(null, OrderPosition.LAST);

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  private String relativeID;
  private OrderPosition type;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  // ------------------------------------------------------------------------
  /**
   * Default Constructor, same as <code>OrderedRelationPosition(null,
   * OrderPosition.LAST)</code>
   */
  public OrderedRelationPosition() {

    this.type = OrderPosition.LAST;
    this.relativeID = null;

  }


  // ------------------------------------------------------------------------
  /**
   * Constructor.
   *
   * @param relativeID TBD: Description of the incoming method parameter
   * @param type TBD: Description of the incoming method parameter
   */
  public OrderedRelationPosition(String relativeID,
    OrderPosition type) {

    this.type = type;
    if (this.type == null) {
      this.type = OrderPosition.LAST;
    }

    this.relativeID = relativeID;
    if (this.relativeID == null) {
      if (OrderPosition.BEFORE.equals(this.type)) {
        this.type = OrderPosition.FIRST;
      }
      else if (OrderPosition.AFTER.equals(this.type)) {
        this.type = OrderPosition.LAST;
      }
    }
    else {
      if (OrderPosition.FIRST.equals(this.type)) {
        this.relativeID = null;
      }
      else if (OrderPosition.LAST.equals(this.type)) {
        this.relativeID = null;
      }
    }

  }


  // ------
  // Object -------------------------------------------------------------------
  // ------

  // ------------------------------------------------------------------------
  public boolean equals(Object object) {

    if (object == null) {
      return false;
    }

    if (object instanceof OrderedRelationPosition) {
      OrderedRelationPosition other = (OrderedRelationPosition)object;
      return (this.relativeID.equals(other.relativeID) && this.type.equals(other.type));
    }

    if (object instanceof IOrderedRelationPosition) {
      IOrderedRelationPosition other = (IOrderedRelationPosition)object;
      return (this.relativeID.equals(other.getRelativeID()) && this.type.equals(other.getType()));
    }

    return false;
  }


  // ------------------------
  // IOrderedRelationPosition -------------------------------------------------
  // ------------------------

  // ------------------------------------------------------------------------
  public OrderPosition getType() {

    return this.type;
  }


  // ------------------------------------------------------------------------
  public String getRelativeID() {

    return this.relativeID;
  }

}
