/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationTypeListIterator.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * An iterator for <code>IRelationType</code> s in a <code>IRelationTypeList
 * </code>. <br>
 *
 */
public interface IRelationTypeListIterator {

  /**
   * Returns <code>true</code> if this list iterator has more elements when
   * traversing the list in the forward direction. (In other words, returns
   * <code>true</code> if <code>next()</code> would return an element rather
   * than throwing an exception.)
   *
   * @return <code>true</code> if the list iterator has more elements when
   *      traversing the list in the forward direction.
   */
  public boolean hasNext();


  /**
   * Returns the next element in the list. This method may be called repeatedly
   * to iterate through the list, or intermixed with calls to <code>previous()
   * </code> to go back and forth. (Note that alternating calls to next and
   * previous will return the same element repeatedly.)
   *
   * @return the next element in the list.
   * @throws java.util.NoSuchElementException if the iteration has no next
   *      element.
   */
  public IRelationType next();

  /**
   * Returns <code>true</code> if this list iterator has more elements when
   * traversing the list in the reverse direction. (In other words, returns
   * <code>true</code> if <cdoe>previous()</code> would return an element rather
   * than throwing an exception.)
   *
   * @return <code>true</code> if the list iterator has more elements when
   *      traversing the list in the reverse direction
   */
  public boolean hasPrevious();


  /**
   * Returns the previous element in the list. This method may be called
   * repeatedly to iterate through the list backwards, or intermixed with calls
   * to <code>next()</code> to go back and forth. (Note that alternating calls
   * to next and previous will return the same element repeatedly.)
   *
   * @return the previous element in the list.
   * @throws java.util.NoSuchElementException if the iteration has no
   *      previous element.
   */
  public IRelationType previous();


  /**
   * Returns the index of the element that would be returned by a subsequent
   * call to <code>next()</code> . (Returns list size if the list iterator is at
   * the end of the list.)
   *
   * @return the index of the element that would be returned by a subsequent
   *      call to <code>next()</code> , or list size if list iterator is at end
   *      of list.
   */
  public int nextIndex();


  /**
   * Returns the index of the element that would be returned by a subsequent
   * call to <code>previous()</code> . (Returns <code>-1</code> if the list
   * iterator is at the beginning of the list.)
   *
   * @return the index of the element that would be returned by a subsequent
   *      call to <code>previous()</code> , or <code>-1</code> if list iterator
   *      is at beginning of list.
   */
  public int previousIndex();


  /**
   * Removes from the list the last element that was returned by <code>next()
   * </code> or <code>previous()</code> . This call can only be made once per
   * call to <code>next()</code> or <code>previous()</code> . It can be made
   * only if <code>add()</code> has not been called after the last call to
   * <code>next()</code> or <code>previous</code> .
   *
   * @throws IllegalStateException neither <code>next()</code> nor
   *      <code>previous()</code> have been called, or <code>remove()</code> or
   *      <code>add()</code> have been called after the last call to <code>
   *      next()</code> or <code>previous()</code>
   */
  public void remove();


  /**
   * Replaces the last element returned by <code>next()</code> or <code>
   * previous()</code> with the specified element. This call can be made only if
   * neither <code>remove()</code> nor <code>add()</code> have been called after
   * the last call to <code>next()</code> or <code>previous()</code> .
   *
   * @param relationType the element with which to replace the last element
   *      returned by <code>next()</code> or <code>previous()</code> .
   * @throws IllegalArgumentException if some aspect of the
   *      specified element prevents it from being added to this list.
   * @throws IllegalStateException if neither <code>next()</code>
   *      nor <code>previous()</code> have been called, or <code>remove()</code>
   *      or <code>add()</code> have been called after the last call to <code>
   *      next()</code> or <code>previous()</code>
   */
  public void set(IRelationType relationType);


  /**
   * Inserts the specified element into the list. The element is inserted
   * immediately before the next element that would be returned by <code>next()
   * </code>, if any, and after the next element that would be returned by
   * <code>previous()</code> , if any. (If the list contains no elements, the
   * new element becomes the sole element on the list.) The new element is
   * inserted before the implicit cursor: a subsequent call to <code>next()
   * </code> would be unaffected, and a subsequent call to <code>previous()
   * </code> would return the new element. (This call increases by one the value
   * that would be returned by a call to <code>nextIndex()</code> or <code>
   * previousIndex()</code> .)
   *
   * @param relationType the element to insert.
   * @throws IllegalArgumentException if some aspect of the
   *      specified element prevents it from being added to this list.
   */
  public void add(IRelationType relationType);

}
