/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationTypeHandler.java#1 $
 */

package com.sapportals.wcm.service.relation;

/**
 * The handler for a <code>IRelationType</code> . <br>
 * A <code>IRelationTypeHandler</code> defines the 'workarea' of a <code>
 * IRelationType</code> , things like the cache to use and the tablespace to
 * store the relations in.
 */
public interface IRelationTypeHandler {

  /**
   * Get the type handler's id.
   *
   * @return a <code>String</code> with the id of this handler.
   */
  public String getID();

}
