/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationTypeAttributes.java#1 $
 */

package com.sapportals.wcm.service.relation;

import com.sapportals.wcm.repository.IPropertyNameList;

/**
 * The attributes of a <code>IRelationType</code> . <br>
 * <code>IRelationTypeAttributes</code> define:
 * <ul>
 *   <li> the meta data for the <code>IRelation</code> s, that are the required
 *   properties</li>
 *   <li> constraints for the <code>IRelation/<code>s, like deletion of a
 *   relation if their source operand is deleted</li>
 *   <li> the <code>IRelationTypeHandler</code> , which defines the 'workarea'
 *   of the relation type</li>
 * </ul>
 *
 */
public interface IRelationTypeAttributes {

  /**
   * Get the relation type's handler.
   *
   * @return a <code>IRelationTypeHandler</code> which specifies the handler for
   *      the relation type.
   */
  public IRelationTypeHandler getTypeHandler();


  /**
   * Get the list of required properties for the relations of this type. <br>
   * Not yet supported!
   *
   * @return a <code>IPropertyNameList</code> with the required properties for
   *      the relations of this relation type, might be empty.
   */
  public IPropertyNameList getRequiredProperties();


  /**
   * True, if only 1:1 relations are allowed (only one relation per source
   * operand).
   *
   * @return a <code>boolean</code> <code>true</code> , if only 1:1 relations
   *      are allowed.
   */
  public boolean isOneToOne();


  /**
   * True, if the relations are ordered with respect to their source operand.
   * <br>
   * <b>(not yet implemented)</b> <br>
   *
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are ordered
   *      within that type and source operand.
   */
  public boolean isOrdered();


  /**
   * True, if the relations will be deleted, when their source operand is
   * deleted.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are deleted
   *      when their source operand gets deleted.
   */
  public boolean isSourceDeleteTrackingEnabled();


  /**
   * True, if the relations will be deleted, when their target operand is
   * deleted.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are deleted
   *      when their target operand gets deleted.
   */
  public boolean isTargetDeleteTrackingEnabled();


  /**
   * True, if the relations are updated, when object which are referenced by the
   * source operands, are renamed.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are updated
   *      when the referenced source operand object gets renamed. Warning: if
   *      renaming the object referenced by the source operand violates the
   *      constraint defined by the source operand's type, the relation will be
   *      deleted if this flag is enabled.
   */
  public boolean isSourceChangeTrackingEnabled();


  /**
   * True, if the relations are updated, when object which are referenced by the
   * target operands, are renamed.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are updated
   *      when the referenced target operand object gets renamed. Warning: if
   *      renaming the object referenced by the target operand violates the
   *      constraint defined by the target operand's type, the relation will be
   *      deleted if this flag is enabled.
   */
  public boolean isTargetChangeTrackingEnabled();


  /**
   * True, if relations are to be copied, when an object referenced by a source
   * operand, was copied.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are updated
   *      when the referenced source operand object gets renamed. Warning: if
   *      renaming the object referenced by the source operand violates the
   *      constraint defined by the source operand's type, the relation will be
   *      deleted if this flag is enabled.
   */
  public boolean isSourceCopyTrackingEnabled();


  /**
   * True, if the relations are updated, when object which are referenced by the
   * target operands, are renamed.
   *
   * @return a <code>boolean</code> <code>true</code> , if relations are updated
   *      when the referenced target operand object gets renamed. Warning: if
   *      renaming the object referenced by the target operand violates the
   *      constraint defined by the target operand's type, the relation will be
   *      deleted if this flag is enabled.
   */
  public boolean isTargetCopyTrackingEnabled();

}
