/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationQueryOrder.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * An expression used by the <code>IQueryBuilder</code> . <br>
 *
 */
public interface IRelationQueryOrder {

  /**
   * Reverse the order of this query order.
   *
   * @return the <code>IRelationQueryOrder</code> in descending order.
   */
  public IRelationQueryOrder descending();


  /**
   * Combine the given query order with this one by appending it (making the
   * order from the parameter the second ordering criteria for this one).
   *
   * @param order the <code>IRelationQueryOrder</code> to append to this one.
   * @return TBD: Description of the outgoing return value
   * @throws RelationQueryException if the given order is not
   *      understood by this query order's query builder.
   */
  public IRelationQueryOrder and(IRelationQueryOrder order)
    throws RelationQueryException;

}
