/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationQuery.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * An query expression to select <code>IRelation</code> s. <br>
 *
 */
public interface IRelationQuery {

  /**
   * Negate the given query (select all those relations not selected by the
   * given query).
   *
   * @return the <code>IRelationQuery/code> with the inverted query expression.
   */
  public IRelationQuery not();


  /**
   * Combine the given query with this one via logical <code>AND</code> (select
   * only those wich are in both queries).
   *
   * @param query TBD: Description of the incoming method parameter
   * @return the <code>IRelationQuery/code> with the <code>AND</code> ed query
   *      expression.
   * @throws RelationQueryException if the given query is not
   *      understood by this query's builder.
   */
  public IRelationQuery and(IRelationQuery query)
    throws RelationQueryException;


  /**
   * Combine the given query with this one via logical <code>OR</code> (select
   * all those selected by either one or both of the queries).
   *
   * @param query TBD: Description of the incoming method parameter
   * @return the <code>IRelationQuery/code> with the <code>OR</code> ed query
   *      expression.
   * @throws RelationQueryException if the given query is not
   *      understood by this query's builder.
   */
  public IRelationQuery or(IRelationQuery query)
    throws RelationQueryException;

}
