/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IRelationPropertyQuery.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * A term used by the <code>IRelationQueryBuilder</code> . <br>
 *
 */
public interface IRelationPropertyQuery
   extends IRelationOperandQuery {

  /**
   * Return an expression which selects only those operands matching the given
   * object (<code>compareTo() = 0</code> ).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery equal(Object value);


  /**
   * Return an expression which selects only those operands being less than the
   * given object (<code>compareTo() < 0</code> ).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery less(Object value);


  /**
   * Return an expression which selects only those operands being less or equal
   * than the given object (<code>compareTo() <= 0</code> ).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery lessEqual(Object value);


  /**
   * Return an expression which selects only those operands being greater than
   * the given object (<code>compareTo() > 0</code> ).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery greater(Object value);


  /**
   * Return an expression which selects only those operands being greater or
   * equal than the given object (<code>compareTo() >= 0</code> ).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery greaterEqual(Object value);


  /**
   * Return an expression which selects only those operands being between the
   * given objects (<code>compareTo(lowerValue) <= 0 and compareTo(upperValue >=
   * 0)</code> ).
   *
   * @param lowerValue TBD: Description of the incoming method parameter
   * @param upperValue TBD: Description of the incoming method parameter
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery between(Object lowerValue,
    Object upperValue);


  /**
   * Return an expression which selects only those operands where a value
   * exists.
   *
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery exists();


  /**
   * Return an expression which selects only those operands having more than one
   * value.
   *
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery isMultivalued();


  /**
   * Return an expression which selects only those operands having at least one
   * value matching the given String.
   *
   * @param value the <code>String</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery contains(String value);


  /**
   * case insensitive version of {@link #contains(String)}.
   *
   * @param value TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public IRelationQuery containsIgnoreCase(String value);


  /**
   * Return an expression which selects only those operands having at least one
   * value matching the given Object (compare gives 0).
   *
   * @param value the <code>Object</code> to compare this term with.
   * @return the <code>IRelationQuery</code> .
   */
  public IRelationQuery contains(Object value);

}
