/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IOrderedRelationType.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * A relation type, which supports ordering on it's relations. <br>
 * This interface is just for tagging ordered relation types. <br>
 * The relations can only be ordered with respect to the same source operand.
 * E.g. let there be <i>R11</i> =(<i>S1</i> ,<i>T1</i> ), <i>R12</i> =(<i>S1</i>
 * ,<i>T2</i> ) and <i>R23</i> =(<i>S2</i> ,<i>T3</i> ). Then it would be
 * possible have <i>R12</i> being sorted after <i>R11</i> in the result of
 * {@link IRelationType#getRelations(IRelationOperand)}, but the client won't be
 * able to influence the position of <i>R23</i> when getting all relations with
 * {@link IRelationType#getRelations()}.
 */
public interface IOrderedRelationType
   extends IRelationType {
}
