/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IOrderedRelationPositioningListIterator.java#2 $
 */

package com.sapportals.wcm.service.relation;

/**
 * An iterator for <code>IOrdererdRelationPositiongList</code> s. <br>
 *
 */
public interface IOrderedRelationPositioningListIterator {

  /**
   * Test for further available elements.
   *
   * @return a <code>boolean</code> <code>true</code> if there are more elements
   *      available (if <code>next()</code> would return a value</code> ).
   */
  public boolean hasNext();


  /**
   * Get the next available element.
   *
   * @return a <code>IOrderedRelationPositioning</code> with the next element,
   *      if it exists.
   * @throws java.util.NoSuchElementException if no next element exists for
   *      this iterator (if the end of the list has been reached).
   */
  public IOrderedRelationPositioning next();

}
