/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/60NW_SP_COR/src/_relation/java/api/com/sapportals/wcm/service/relation/IOrderedRelationPositioningList.java#2 $
 */

package com.sapportals.wcm.service.relation;

import java.util.Collection;

/**
 * A list for <code>IOrderedRelationPositioning</code> s. <br>
 *
 */
public interface IOrderedRelationPositioningList {

  /**
   * Return this typed list as an standard java collection.
   *
   * @return a <code>Collection</code> representing this typed list.
   */
  public Collection getCollection();


  /**
   * Return the number of positioning objects in the list.
   *
   * @return an <code>int</code> with the number of elements in the list.
   */
  public int size();


  /**
   * Appends the specified positioning object to the end of the list.
   *
   * @param positioning the <code>IOrderedRelationPositioning</code> element to
   *      add.
   * @return a <code>boolean</code> <code>true</code> .
   */
  public boolean add(IOrderedRelationPositioning positioning);


  /**
   * Appends the specified realtion and position as a new positioning object to
   * the end of the list.
   *
   * @param relationID a <code>String</code> with the id of the relation to use
   *      for the positioning element to add.
   * @param position the <code>IOrderedRelationPosition</code> to use for the
   *      positioning element to add.
   * @return a <code>boolean</code> <code>true</code> .
   */
  public boolean add(String relationID,
    IOrderedRelationPosition position);


  /**
   * Returns the positioning object with the specified index in the list.
   *
   * @param index an <code>int</code> with the index to lookup.
   * @return a <code>IOrderedRelationPosition</code> with the element at the
   *      specified index.
   * @throws IndexOutOfBoundsException if the index is out of
   *      range (index < 0 || index >= size()).
   */
  public IOrderedRelationPositioning get(int index);


  /**
   * Inserts the specified positioning object at the specified position in the
   * list.
   *
   * @param index an <code>int</code> with the index to insert the element at.
   *      the existing element at and those elements after this index are
   *      shifted to the right (one is added to their index).
   * @param positioning the <code>IOrderedRelationPositioning</code> element to
   *      insert.
   * @throws IndexOutOfBoundsException if the index is out of
   *      range (index < 0 || index >= size()).
   */
  public void add(int index,
    IOrderedRelationPositioning positioning);


  /**
   * Inserts the specified relation and position as a new positioning object at
   * the specified position in the list.
   *
   * @param index an <code>int</code> with the index to insert the element at.
   *      the existing element at and those elements after this index are
   *      shifted to the right (one is added to their index).
   * @param relationID a <code>String</code> with the id of the relation to use
   *      for the positioning element to add.
   * @param position the <code>IOrderedRelationPosition</code> to use for the
   *      positioning element to add.
   * @throws IndexOutOfBoundsException if the index is out of
   *      range (index < 0 || index >= size()).
   */
  public void add(int index,
    String relationID,
    IOrderedRelationPosition position);


  /**
   * Returns a list iterator.
   *
   * @return a <code>IOrderedRelationPositioningListIterator</code> with an
   *      iterator for the list.
   */
  public IOrderedRelationPositioningListIterator listIterator();


  /**
   * Returns a list iterator.
   *
   * @param index an <code>int</code> with the position to start the iterator
   *      at.
   * @return a <code>IOrderedRelationPositioningListIterator</code> with an
   *      iterator for the list and the specified start.
   * @throws IndexOutOfBoundsException if the index is out of
   *      range (index < 0 || index >= size()).
   */
  public IOrderedRelationPositioningListIterator listIterator(int index);

}
